/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.registry;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.apparatus.calcinationoven.CalcinationOvenBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.distiller.DistillerBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.LiquefactionCauldronBlockEntity;
import com.klikli_dev.theurgy.content.capability.HeatProvider;
import com.klikli_dev.theurgy.content.capability.HeatReceiver;
import com.klikli_dev.theurgy.content.capability.MercuryFluxStorage;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityRegistry {
    public static final BlockCapability<MercuryFluxStorage, @Nullable Direction> MERCURY_FLUX_HANDLER = BlockCapability.createSided((ResourceLocation)Theurgy.loc("mercury_flux_handler"), MercuryFluxStorage.class);
    public static BlockCapability<HeatProvider, @Nullable Direction> HEAT_PROVIDER = BlockCapability.createSided((ResourceLocation)Theurgy.loc("heat_provider"), HeatProvider.class);
    public static BlockCapability<HeatReceiver, @Nullable Direction> HEAT_RECEIVER = BlockCapability.createSided((ResourceLocation)Theurgy.loc("heat_receiver"), HeatReceiver.class);

    private static <E extends BlockEntity, T, C> T doubleBlockCapability(Level level, BlockPos pos, @Nullable BlockEntity blockEntity, C context, Class<E> clazz, BiFunction<E, C, T> propertyGetter) {
        BlockPos below;
        BlockEntity blockEntityBelow;
        if (clazz.isInstance(blockEntity)) {
            return propertyGetter.apply((BlockEntity)clazz.cast(blockEntity), context);
        }
        if (level.getBlockState(pos).getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER && clazz.isInstance(blockEntityBelow = level.getBlockEntity(below = pos.below()))) {
            return propertyGetter.apply((BlockEntity)clazz.cast(blockEntityBelow), context);
        }
        return null;
    }

    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        CapabilityRegistry.registerCalcinationOven(event);
        CapabilityRegistry.registerCaloricFluxEmitter(event);
        CapabilityRegistry.registerDigestionVat(event);
        CapabilityRegistry.registerDistiller(event);
        CapabilityRegistry.registerFermentationVat(event);
        CapabilityRegistry.registerIncubator(event);
        CapabilityRegistry.registerLiquefactionCauldron(event);
        CapabilityRegistry.registerMercuryCatalyst(event);
        CapabilityRegistry.registerPyromanticBrazier(event);
        CapabilityRegistry.registerReformationArray(event);
        CapabilityRegistry.registerSalAmmoniacAccumulator(event);
        CapabilityRegistry.registerSalAmmoniacTank(event);
    }

    public static void registerCalcinationOven(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, context) -> (IItemHandler)CapabilityRegistry.doubleBlockCapability(level, pos, be, context, CalcinationOvenBlockEntity.class, (blockEntity, side) -> {
            if (side == Direction.UP) {
                return blockEntity.storageBehaviour.inputInventory;
            }
            if (side == Direction.DOWN) {
                return blockEntity.storageBehaviour.outputInventoryExtractOnlyWrapper;
            }
            return blockEntity.storageBehaviour.inventory;
        }), new Block[]{(Block)BlockRegistry.CALCINATION_OVEN.get()});
        event.registerBlockEntity(HEAT_RECEIVER, BlockEntityRegistry.CALCINATION_OVEN.get(), (blockEntity, side) -> blockEntity.heatReceiver);
    }

    public static void registerCaloricFluxEmitter(@NotNull RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(MERCURY_FLUX_HANDLER, BlockEntityRegistry.CALORIC_FLUX_EMITTER.get(), (blockEntity, side) -> blockEntity.mercuryFluxStorage);
    }

    public static void registerDigestionVat(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityRegistry.DIGESTION_VAT.get(), (blockEntity, side) -> {
            Boolean isOpen = (Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.OPEN);
            if (side == Direction.UP) {
                return isOpen != false ? blockEntity.storageBehaviour.inputInventory : blockEntity.storageBehaviour.inputInventoryReadOnlyWrapper;
            }
            if (side == Direction.DOWN) {
                return isOpen != false ? blockEntity.storageBehaviour.outputInventoryExtractOnlyWrapper : blockEntity.storageBehaviour.outputInventoryReadOnlyWrapper;
            }
            return isOpen != false ? blockEntity.storageBehaviour.inventory : blockEntity.storageBehaviour.inventoryReadOnlyWrapper;
        });
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, BlockEntityRegistry.DIGESTION_VAT.get(), (blockEntity, side) -> {
            Boolean isOpen = (Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.OPEN);
            return isOpen != false ? blockEntity.storageBehaviour.fluidTank : blockEntity.storageBehaviour.fluidTankReadOnlyWrapper;
        });
    }

    public static void registerDistiller(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, context) -> (IItemHandler)CapabilityRegistry.doubleBlockCapability(level, pos, be, context, DistillerBlockEntity.class, (blockEntity, side) -> {
            if (side == Direction.UP) {
                return blockEntity.storageBehaviour.inputInventory;
            }
            if (side == Direction.DOWN) {
                return blockEntity.storageBehaviour.outputInventoryExtractOnlyWrapper;
            }
            return blockEntity.storageBehaviour.inventory;
        }), new Block[]{(Block)BlockRegistry.DISTILLER.get()});
        event.registerBlockEntity(HEAT_RECEIVER, BlockEntityRegistry.DISTILLER.get(), (blockEntity, side) -> blockEntity.heatReceiver);
    }

    public static void registerFermentationVat(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityRegistry.FERMENTATION_VAT.get(), (blockEntity, side) -> {
            Boolean isOpen = (Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.OPEN);
            if (side == Direction.UP) {
                return isOpen != false ? blockEntity.storageBehaviour.inputInventory : blockEntity.storageBehaviour.inputInventoryReadOnlyWrapper;
            }
            if (side == Direction.DOWN) {
                return isOpen != false ? blockEntity.storageBehaviour.outputInventoryExtractOnlyWrapper : blockEntity.storageBehaviour.outputInventoryReadOnlyWrapper;
            }
            return isOpen != false ? blockEntity.storageBehaviour.inventory : blockEntity.storageBehaviour.inventoryReadOnlyWrapper;
        });
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, BlockEntityRegistry.FERMENTATION_VAT.get(), (blockEntity, side) -> {
            Boolean isOpen = (Boolean)blockEntity.getBlockState().getValue((Property)BlockStateProperties.OPEN);
            return isOpen != false ? blockEntity.storageBehaviour.fluidTank : blockEntity.storageBehaviour.fluidTankReadOnlyWrapper;
        });
    }

    public static void registerIncubator(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, context) -> (IItemHandler)CapabilityRegistry.doubleBlockCapability(level, pos, be, context, IncubatorBlockEntity.class, (blockEntity, side) -> blockEntity.outputInventoryTakeOnlyWrapper), new Block[]{(Block)BlockRegistry.INCUBATOR.get()});
        event.registerBlockEntity(HEAT_RECEIVER, BlockEntityRegistry.INCUBATOR.get(), (blockEntity, side) -> blockEntity.heatReceiver);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityRegistry.INCUBATOR_SULFUR_VESSEL.get(), (blockEntity, side) -> blockEntity.inputInventory);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityRegistry.INCUBATOR_SALT_VESSEL.get(), (blockEntity, side) -> blockEntity.inputInventory);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityRegistry.INCUBATOR_MERCURY_VESSEL.get(), (blockEntity, side) -> blockEntity.inputInventory);
    }

    public static void registerLiquefactionCauldron(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(HEAT_RECEIVER, BlockEntityRegistry.LIQUEFACTION_CAULDRON.get(), (blockEntity, side) -> blockEntity.heatReceiver);
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, context) -> (IItemHandler)CapabilityRegistry.doubleBlockCapability(level, pos, be, context, LiquefactionCauldronBlockEntity.class, (blockEntity, side) -> {
            if (side == Direction.UP) {
                return blockEntity.storageBehaviour.inputInventory;
            }
            if (side == Direction.DOWN) {
                return blockEntity.storageBehaviour.outputInventory;
            }
            return blockEntity.storageBehaviour.inventory;
        }), new Block[]{(Block)BlockRegistry.LIQUEFACTION_CAULDRON.get()});
        event.registerBlock(Capabilities.FluidHandler.BLOCK, (level, pos, state, be, context) -> (IFluidHandler)CapabilityRegistry.doubleBlockCapability(level, pos, be, context, LiquefactionCauldronBlockEntity.class, (blockEntity, c) -> blockEntity.storageBehaviour.solventTank), new Block[]{(Block)BlockRegistry.LIQUEFACTION_CAULDRON.get()});
    }

    public static void registerMercuryCatalyst(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(MERCURY_FLUX_HANDLER, BlockEntityRegistry.MERCURY_CATALYST.get(), (blockEntity, side) -> blockEntity.mercuryFluxStorage);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityRegistry.MERCURY_CATALYST.get(), (blockEntity, side) -> blockEntity.inventory);
    }

    public static void registerPyromanticBrazier(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityRegistry.PYROMANTIC_BRAZIER.get(), (blockEntity, side) -> blockEntity.inventory);
        event.registerBlockEntity(HEAT_PROVIDER, BlockEntityRegistry.PYROMANTIC_BRAZIER.get(), (blockEntity, side) -> blockEntity.heatProvider);
    }

    public static void registerReformationArray(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(MERCURY_FLUX_HANDLER, BlockEntityRegistry.SULFURIC_FLUX_EMITTER.get(), (blockEntity, side) -> blockEntity.mercuryFluxStorage);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityRegistry.REFORMATION_RESULT_PEDESTAL.get(), (blockEntity, side) -> blockEntity.outputInventoryTakeOnlyWrapper);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityRegistry.REFORMATION_TARGET_PEDESTAL.get(), (blockEntity, side) -> blockEntity.inputInventory);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityRegistry.REFORMATION_SOURCE_PEDESTAL.get(), (blockEntity, side) -> blockEntity.inputInventory);
    }

    public static void registerSalAmmoniacAccumulator(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, BlockEntityRegistry.SAL_AMMONIAC_ACCUMULATOR.get(), (blockEntity, side) -> blockEntity.inventory);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, BlockEntityRegistry.SAL_AMMONIAC_ACCUMULATOR.get(), (blockEntity, side) -> blockEntity.waterTank);
    }

    public static void registerSalAmmoniacTank(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, BlockEntityRegistry.SAL_AMMONIAC_TANK.get(), (blockEntity, side) -> blockEntity.tank);
    }
}

