/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.logistics;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.klikli_dev.modonomicon.util.Codecs;
import com.klikli_dev.theurgy.logistics.Wire;
import com.klikli_dev.theurgy.logistics.WireRenderer;
import com.klikli_dev.theurgy.logistics.WireSlackHelper;
import com.klikli_dev.theurgy.logistics.WireSync;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.event.level.LevelEvent;

public class Wires
extends SavedData {
    public static final String ID = "theurgy.wires";
    public static final Codec<Wires> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.set(Wire.CODEC).fieldOf("wireConnections").forGetter(wires -> wires.wires), (App)Codec.BOOL.fieldOf("isClient").forGetter(wires -> wires.isClient)).apply((Applicative)instance, Wires::new));
    private static final String NBT_TAG = "theurgy:wires";
    private static WeakReference<ServerLevel> cachedServerLevel = new WeakReference<Object>(null);
    private static WeakReference<Wires> cachedServerWires = new WeakReference<Object>(null);
    private static WeakReference<Level> cachedClientLevel = new WeakReference<Object>(null);
    private static WeakReference<Wires> cachedClientWires = new WeakReference<Object>(null);
    private final Set<Wire> wires = new ObjectOpenHashSet();
    private final SetMultimap<ChunkPos, Wire> chunkToWires = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final SetMultimap<Wire, ChunkPos> wiresToChunk = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final SetMultimap<BlockPos, Wire> blockPosToWire = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final boolean isClient;

    public Wires(boolean isClient) {
        this.isClient = isClient;
    }

    public Wires(Set<Wire> wires, boolean isClient) {
        this(isClient);
        if (!isClient) {
            this.wires.addAll(wires);
            this.wires.forEach(wire -> {
                this.calculateChunkPosForWire((Wire)wire).forEach(chunkPos -> {
                    this.chunkToWires.put(chunkPos, wire);
                    this.wiresToChunk.put(wire, chunkPos);
                });
                this.blockPosToWire.put((Object)wire.from(), wire);
                this.blockPosToWire.put((Object)wire.to(), wire);
            });
        }
    }

    public Set<Wire> getWires(BlockPos pos) {
        return this.blockPosToWire.get((Object)pos);
    }

    public Set<Wire> getWires(ChunkPos chunk) {
        return this.chunkToWires.get((Object)chunk);
    }

    public Set<ChunkPos> getChunks(Wire wire) {
        return this.wiresToChunk.get((Object)wire);
    }

    public static Wires get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (cachedServerLevel.get() == level && cachedServerWires.get() != null) {
                return (Wires)((Object)cachedServerWires.get());
            }
            Wires wires = (Wires)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new Wires(false), Wires::load, DataFixTypes.LEVEL), ID);
            cachedServerLevel = new WeakReference<ServerLevel>(serverLevel);
            cachedServerWires = new WeakReference<Wires>(wires);
            return wires;
        }
        if (cachedClientLevel.get() == level && cachedClientWires.get() != null) {
            return (Wires)((Object)cachedClientWires.get());
        }
        Wires wires = new Wires(true);
        cachedClientLevel = new WeakReference<Level>(level);
        cachedClientWires = new WeakReference<Wires>(wires);
        return wires;
    }

    public static void onLevelUnload(LevelEvent.Unload event) {
        if (event.getLevel() == cachedServerLevel.get()) {
            cachedServerLevel = new WeakReference<Object>(null);
            cachedServerWires = new WeakReference<Object>(null);
        } else if (event.getLevel() == cachedClientLevel.get()) {
            cachedClientLevel = new WeakReference<Object>(null);
            cachedClientWires = new WeakReference<Object>(null);
            WireRenderer.get().wires.clear();
        }
    }

    public static Wires load(CompoundTag pCompoundTag, HolderLookup.Provider pRegistries) {
        return (Wires)((Object)CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pCompoundTag.get(NBT_TAG)).result().orElseThrow());
    }

    Stream<ChunkPos> calculateChunkPosForWire(Wire wire) {
        return Arrays.stream(WireSlackHelper.getInterpolatedPoints(wire.from().getCenter(), wire.to().getCenter())).map(pos -> new ChunkPos(SectionPos.blockToSectionCoord((double)pos.x()), SectionPos.blockToSectionCoord((double)pos.z())));
    }

    public void addWire(Wire wire) {
        if (this.isClient) {
            WireRenderer.get().wires.add(wire);
        } else {
            this.wires.add(wire);
            this.calculateChunkPosForWire(wire).forEach(chunkPos -> {
                this.chunkToWires.put(chunkPos, (Object)wire);
                this.wiresToChunk.put((Object)wire, chunkPos);
            });
            this.blockPosToWire.put((Object)wire.from(), (Object)wire);
            this.blockPosToWire.put((Object)wire.to(), (Object)wire);
            WireSync.get().sendAddWireToWatchingPlayers((ServerLevel)cachedServerLevel.get(), wire);
        }
        this.setDirty();
    }

    public int removeWiresFor(BlockPos pos) {
        Set<Wire> wires = this.getWires(pos);
        ArrayList<Wire> copy = new ArrayList<Wire>(wires);
        copy.forEach(this::removeWire);
        return copy.size();
    }

    public void removeWire(Wire wire) {
        if (this.isClient) {
            WireRenderer.get().wires.remove(wire);
        } else {
            WireSync.get().sendRemoveWireToWatchingPlayers((ServerLevel)cachedServerLevel.get(), wire);
            this.wires.remove(wire);
            this.blockPosToWire.remove((Object)wire.from(), (Object)wire);
            this.blockPosToWire.remove((Object)wire.to(), (Object)wire);
            Set chunks = this.wiresToChunk.get((Object)wire);
            for (ChunkPos chunkPos : chunks) {
                this.chunkToWires.remove((Object)chunkPos, (Object)wire);
            }
            this.wiresToChunk.removeAll((Object)wire);
        }
        this.setDirty();
    }

    public CompoundTag save(CompoundTag pCompoundTag, HolderLookup.Provider pRegistries) {
        pCompoundTag.put(NBT_TAG, (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).result().orElseThrow());
        return pCompoundTag;
    }
}

