/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.logistics;

import com.klikli_dev.theurgy.logistics.Wire;
import com.klikli_dev.theurgy.logistics.WireSlackHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class WireRenderer {
    private static final WireRenderer instance = new WireRenderer();
    public Set<Wire> wires = Collections.synchronizedSet(new ObjectOpenHashSet());

    public static WireRenderer get() {
        return instance;
    }

    public void onRenderLevelStage(RenderLevelStageEvent event) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        PoseStack poseStack = event.getPoseStack();
        EntityRenderDispatcher erd = Minecraft.getInstance().getEntityRenderDispatcher();
        double renderPosX = erd.camera.getPosition().x();
        double renderPosY = erd.camera.getPosition().y();
        double renderPosZ = erd.camera.getPosition().z();
        poseStack.pushPose();
        poseStack.translate(-renderPosX, -renderPosY, -renderPosZ);
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lines());
        for (Wire wire : this.wires) {
            poseStack.pushPose();
            poseStack.translate((float)wire.from().getX(), (float)wire.from().getY(), (float)wire.from().getZ());
            this.renderWire(buffer, poseStack, wire.from().getCenter(), wire.to().getCenter());
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private void renderWire(VertexConsumer vertexBuilder, PoseStack poseStack, Vec3 startPos, Vec3 endPos) {
        poseStack.pushPose();
        boolean translateSwap = false;
        if (startPos.y() > endPos.y()) {
            Vec3 swap = startPos;
            startPos = endPos;
            endPos = swap;
            translateSwap = true;
        }
        poseStack.translate(0.5, 0.5, 0.5);
        double startX = startPos.x();
        double startY = startPos.y();
        double startZ = startPos.z();
        double endX = endPos.x();
        double endY = endPos.y();
        double endZ = endPos.z();
        float dx = (float)(endX - startX);
        float dy = (float)(endY - startY);
        float dz = (float)(endZ - startZ);
        if (translateSwap) {
            poseStack.translate(-dx, -dy, -dz);
        }
        Matrix4f fourMatrix = poseStack.last().pose();
        Vec3[] points = WireSlackHelper.getInterpolatedDifferences(endPos.subtract(startPos));
        poseStack.pushPose();
        for (int line = 0; line < points.length - 1; ++line) {
            Vec3 firstPoint = points[line];
            Vec3 secondPoint = points[line + 1];
            Vec3 normal = secondPoint.subtract(firstPoint).normalize();
            Vec3 reverseNormal = firstPoint.subtract(secondPoint).normalize();
            vertexBuilder.addVertex(fourMatrix, (float)firstPoint.x(), (float)firstPoint.y(), (float)firstPoint.z()).setColor(0, 0, 0, 255).setNormal(poseStack.last(), (float)normal.x(), (float)normal.y(), (float)normal.z());
            vertexBuilder.addVertex(fourMatrix, (float)secondPoint.x(), (float)secondPoint.y(), (float)secondPoint.z()).setColor(0, 0, 0, 255).setNormal(poseStack.last(), (float)reverseNormal.x(), (float)reverseNormal.y(), (float)reverseNormal.z());
        }
        poseStack.popPose();
        poseStack.popPose();
    }
}

