/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.logistics;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.Traverser;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.behaviour.logistics.HasLeafNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeMode;
import com.klikli_dev.theurgy.content.behaviour.logistics.LogisticsNode;
import com.klikli_dev.theurgy.logistics.LogisticsNetwork;
import com.klikli_dev.theurgy.util.TheurgyExtraCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class Logistics
extends SavedData {
    public static final Supplier<MutableGraph<GlobalPos>> GRAPH_SUPPLIER = () -> GraphBuilder.undirected().allowsSelfLoops(false).build();
    public static final String ID = "theurgy.logistics";
    public static final Codec<Logistics> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TheurgyExtraCodecs.graph(GlobalPos.CODEC, GRAPH_SUPPLIER).fieldOf("graph").forGetter(Logistics::graph)).apply((Applicative)instance, Logistics::new));
    private static final String NBT_TAG = "theurgy:logistics";
    private static Logistics cachedLogistics;
    private final MutableGraph<GlobalPos> graph;
    private final Set<GlobalPos> graphNodes = new ObjectOpenHashSet();
    private final Map<GlobalPos, LogisticsNetwork> blockPosToNetwork = new Object2ObjectOpenHashMap();
    private final Map<GlobalPos, WeakReference<LeafNodeBehaviour<?, ?>>> cachedLeafNodes = new Object2ObjectOpenHashMap();
    private boolean useLeafNodeCache = false;
    private boolean useAutomaticNetworkCacheRebuild = true;

    public Logistics() {
        this(GRAPH_SUPPLIER.get());
    }

    public Logistics(MutableGraph<GlobalPos> graph) {
        this.graph = graph;
        this.rebuildGraph();
    }

    public static Logistics load(CompoundTag pCompoundTag, HolderLookup.Provider pRegistries) {
        return (Logistics)((Object)CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pCompoundTag.get(NBT_TAG)).result().orElseThrow());
    }

    private static MinecraftServer server() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static Logistics get() {
        if (cachedLogistics == null) {
            MinecraftServer server = Logistics.server();
            if (server != null) {
                Logistics logistics;
                cachedLogistics = logistics = (Logistics)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(Logistics::new, Logistics::load, DataFixTypes.LEVEL), ID);
            } else {
                Logistics logistics = new Logistics();
                Theurgy.LOGGER.warn("Logistics accessed client side, this should not happen!");
                cachedLogistics = logistics;
            }
        }
        return cachedLogistics;
    }

    public static void onLevelUnload(LevelEvent.Unload event) {
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && (level = (Level)levelAccessor).dimension() == Level.OVERWORLD) {
            cachedLogistics = null;
        }
    }

    public void enableLeafNodeCache() {
        this.useLeafNodeCache = true;
    }

    public void disableLeafNodeCache() {
        this.useLeafNodeCache = false;
        this.cachedLeafNodes.clear();
    }

    public void disableAutomaticNetworkCacheRebuild() {
        this.useAutomaticNetworkCacheRebuild = false;
    }

    public void enableAutomaticNetworkCacheRebuild() {
        this.useAutomaticNetworkCacheRebuild = true;
    }

    public LogisticsNetwork getNetwork(GlobalPos pos) {
        return this.blockPosToNetwork.get(pos);
    }

    public LeafNodeBehaviour<?, ?> getLeafNode(GlobalPos pos, LeafNodeMode mode) {
        return this.getLeafNode(pos, mode, null);
    }

    public LeafNodeBehaviour<?, ?> getLeafNode(GlobalPos pos) {
        return this.getLeafNode(pos, (BlockCapability)null);
    }

    public <T, C> LeafNodeBehaviour<T, C> getLeafNode(GlobalPos pos, LeafNodeMode mode, BlockCapability<T, C> capability) {
        LeafNodeBehaviour<T, C> node = this.getLeafNode(pos, capability);
        if (node != null && node.mode() == mode) {
            return node;
        }
        return null;
    }

    public <T, C> LeafNodeBehaviour<T, C> getLeafNode(GlobalPos pos, BlockCapability<T, C> capability) {
        WeakReference<LeafNodeBehaviour<?, ?>> weakRef;
        LeafNodeBehaviour result = null;
        if (this.useLeafNodeCache && (weakRef = this.cachedLeafNodes.get(pos)) != null) {
            LeafNodeBehaviour temp = (LeafNodeBehaviour)weakRef.get();
            if (temp != null && (capability == null || temp.capabilityType().equals(capability))) {
                result = temp;
            }
            if (result == null) {
                this.cachedLeafNodes.remove(pos);
            }
        }
        if (result == null) {
            ServerLevel level = Logistics.server().getLevel(pos.dimension());
            if (level == null) {
                return null;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos.pos());
            if (blockEntity instanceof HasLeafNodeBehaviour) {
                HasLeafNodeBehaviour hasLeafNode = (HasLeafNodeBehaviour)blockEntity;
                if (capability == null || hasLeafNode.leafNode().capabilityType().equals(capability)) {
                    result = hasLeafNode.leafNode();
                }
            }
            if (result != null && this.useLeafNodeCache) {
                this.cachedLeafNodes.put(pos, new WeakReference(result));
            }
        }
        return result;
    }

    public boolean isLogisticsNode(GlobalPos pos) {
        ServerLevel level = Logistics.server().getLevel(pos.dimension());
        if (level == null) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos.pos());
        return blockEntity instanceof LogisticsNode;
    }

    public LogisticsNetwork add(LeafNodeBehaviour<?, ?> leafNode) {
        GlobalPos pos = leafNode.globalPos();
        this.add(pos);
        LogisticsNetwork network = this.blockPosToNetwork.get(pos);
        if (network != null) {
            network.addLeafNode(leafNode);
        }
        return network;
    }

    public void remove(LeafNodeBehaviour<?, ?> leafNode, boolean permanently) {
        LogisticsNetwork network = this.blockPosToNetwork.get(leafNode.globalPos());
        if (network != null) {
            network.removeLeafNode(leafNode);
        }
        if (permanently) {
            this.remove(leafNode.globalPos());
        }
    }

    public LogisticsNetwork add(GlobalPos node) {
        boolean isNew = this.graphNodes().add(node);
        if (isNew) {
            this.graph().addNode((Object)node);
            this.setDirty();
            return null;
        }
        Set neighbors = this.graph().adjacentNodes((Object)node);
        for (GlobalPos neighbor : neighbors) {
            this.add(node, neighbor);
        }
        return this.blockPosToNetwork.get(node);
    }

    public void remove(GlobalPos destroyedBlock) {
        if (!this.graphNodes().contains(destroyedBlock)) {
            return;
        }
        Set neighbors = this.graph().adjacentNodes((Object)destroyedBlock);
        this.graph().removeNode((Object)destroyedBlock);
        this.graphNodes().remove(destroyedBlock);
        this.setDirty();
        LogisticsNetwork oldNetwork = this.blockPosToNetwork.get(destroyedBlock);
        if (oldNetwork != null) {
            oldNetwork.removeNode(destroyedBlock);
            this.blockPosToNetwork.remove(destroyedBlock);
        }
        ArrayList<LogisticsNetwork> splitNetworks = new ArrayList<LogisticsNetwork>();
        for (GlobalPos neighbor : neighbors) {
            boolean isNeighborInSplitNetwork = splitNetworks.stream().anyMatch(network -> network.nodes().contains(neighbor));
            if (isNeighborInSplitNetwork) continue;
            LogisticsNetwork newNetwork = this.buildNetwork(neighbor, this.getConnected(neighbor), node -> {});
            splitNetworks.add(newNetwork);
        }
        if (this.useAutomaticNetworkCacheRebuild) {
            splitNetworks.forEach(LogisticsNetwork::rebuildCaches);
        }
    }

    public LogisticsNetwork add(GlobalPos a, GlobalPos b) {
        this.graph().putEdge((Object)a, (Object)b);
        this.graphNodes().add(a);
        this.graphNodes().add(b);
        this.setDirty();
        LogisticsNetwork netA = this.blockPosToNetwork.get(a);
        LogisticsNetwork netB = this.blockPosToNetwork.get(b);
        LogisticsNetwork network = netA == null && netB == null ? new LogisticsNetwork() : (netA == null ? netB : (netB == null ? netA : (netA != netB ? (netA.nodes().size() == 1 ? this.mergeSingle(netB, netA) : (netB.nodes().size() == 1 ? this.mergeSingle(netA, netB) : this.merge(netA, netB))) : netA)));
        network.addNode(a);
        network.addNode(b);
        this.blockPosToNetwork.put(a, network);
        this.blockPosToNetwork.put(b, network);
        return network;
    }

    public void remove(GlobalPos a, GlobalPos b) {
        this.graph().removeEdge((Object)a, (Object)b);
        this.setDirty();
        ObjectOpenHashSet connectedA = new ObjectOpenHashSet();
        this.getConnected(a).forEach(arg_0 -> ((ObjectOpenHashSet)connectedA).add(arg_0));
        if (connectedA.contains((Object)b)) {
            return;
        }
        LogisticsNetwork networkA = this.buildNetwork(a, (Iterable<GlobalPos>)connectedA, node -> {});
        LogisticsNetwork networkB = this.buildNetwork(b, this.getConnected(b), node -> {});
        if (this.useAutomaticNetworkCacheRebuild) {
            networkA.rebuildCaches();
            networkB.rebuildCaches();
        }
    }

    public CompoundTag save(CompoundTag pCompoundTag, HolderLookup.Provider pRegistries) {
        pCompoundTag.put(NBT_TAG, (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).result().orElseThrow());
        return pCompoundTag;
    }

    private MutableGraph<GlobalPos> graph() {
        return this.graph;
    }

    private Set<GlobalPos> graphNodes() {
        return this.graphNodes;
    }

    private Iterable<GlobalPos> getConnected(GlobalPos start) {
        Traverser traverser = Traverser.forGraph(this.graph());
        if (this.graphNodes().contains(start)) {
            return traverser.breadthFirst((Object)start);
        }
        return List.of();
    }

    private void rebuildGraph() {
        this.graphNodes.clear();
        this.blockPosToNetwork.clear();
        for (GlobalPos node : this.graph().nodes()) {
            if (this.graphNodes.contains(node)) continue;
            Iterable<GlobalPos> connected = this.getConnected(node);
            this.buildNetwork(node, connected, this.graphNodes::add);
        }
    }

    private LogisticsNetwork merge(LogisticsNetwork a, LogisticsNetwork b) {
        LogisticsNetwork result = new LogisticsNetwork();
        result.merge(a);
        result.merge(b);
        result.nodes().forEach(pos -> this.blockPosToNetwork.put((GlobalPos)pos, result));
        if (this.useAutomaticNetworkCacheRebuild) {
            result.rebuildCaches();
        }
        return result;
    }

    private LogisticsNetwork mergeSingle(LogisticsNetwork network, LogisticsNetwork singleNodeNetwork) {
        network.merge(singleNodeNetwork);
        return network;
    }

    private LogisticsNetwork buildNetwork(GlobalPos rootNode, Iterable<GlobalPos> connected, Consumer<GlobalPos> onNodeAdded) {
        LogisticsNetwork network = new LogisticsNetwork();
        network.addNode(rootNode);
        this.blockPosToNetwork.put(rootNode, network);
        onNodeAdded.accept(rootNode);
        connected.forEach(c -> {
            network.addNode((GlobalPos)c);
            this.blockPosToNetwork.put((GlobalPos)c, network);
            onNodeAdded.accept((GlobalPos)c);
        });
        return network;
    }
}

