/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public class FermentationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 200;

    public FermentationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "fermentation");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipesForCropTag(ItemTagRegistry.SUGARS);
        this.makeRecipesForCropTag((TagKey<Item>)Tags.Items.CROPS);
    }

    public void makeRecipesForCropTag(TagKey<Item> cropTag) {
        this.makeRecipe((Fluid)Fluids.WATER, 125, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_ABUNDANT, cropTag), (Item)SulfurRegistry.GEMS_ABUNDANT.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 250, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_COMMON, cropTag), (Item)SulfurRegistry.GEMS_COMMON.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 500, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_RARE, cropTag), (Item)SulfurRegistry.GEMS_RARE.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 1000, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_PRECIOUS, cropTag), (Item)SulfurRegistry.GEMS_PRECIOUS.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 125, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_ABUNDANT, cropTag), (Item)SulfurRegistry.METALS_ABUNDANT.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 250, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_COMMON, cropTag), (Item)SulfurRegistry.METALS_COMMON.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 500, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_RARE, cropTag), (Item)SulfurRegistry.METALS_RARE.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 1000, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_PRECIOUS, cropTag), (Item)SulfurRegistry.METALS_PRECIOUS.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 125, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_ABUNDANT, cropTag), (Item)SulfurRegistry.OTHER_MINERALS_ABUNDANT.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 250, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_COMMON, cropTag), (Item)SulfurRegistry.OTHER_MINERALS_COMMON.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 500, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_RARE, cropTag), (Item)SulfurRegistry.OTHER_MINERALS_RARE.get(), 1, 200, "_using_" + this.name(cropTag));
        this.makeRecipe((Fluid)Fluids.WATER, 1000, List.of(ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_PRECIOUS, cropTag), (Item)SulfurRegistry.OTHER_MINERALS_PRECIOUS.get(), 1, 200, "_using_" + this.name(cropTag));
    }

    public void makeRecipe(Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time) {
        this.makeRecipe(this.name((ItemLike)result), fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipe(Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time, String postFix) {
        this.makeRecipe(this.name((ItemLike)result) + postFix, fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipe(String name, Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time) {
        Builder recipe = (Builder)new Builder(new ItemStack((ItemLike)result, resultCount)).fluid(fluid, fluidAmount).time(time);
        ingredients.forEach(recipe::ingredients);
        this.recipeConsumer.accept(this.modLoc(name), recipe.build());
    }

    @NotNull
    public String getName() {
        return "Fermentation Recipes";
    }

    protected static class Builder
    extends JsonRecipeProvider.RecipeBuilder<Builder> {
        protected Builder(ItemStack result) {
            super((Holder<RecipeType<?>>)RecipeTypeRegistry.FERMENTATION);
            this.result(result);
            this.time(200);
        }

        public Builder fluid(TagKey<Fluid> tag, int amount) {
            return (Builder)this.sizedFluidIngredient("fluid", tag, amount);
        }

        public Builder fluid(Fluid fluid, int amount) {
            return (Builder)this.sizedFluidIngredient("fluid", fluid, amount);
        }

        public Builder ingredients(ItemLike item) {
            return this.ingredients(item, 1);
        }

        public Builder ingredients(ItemLike item, int count) {
            if (!this.recipe.has("ingredients")) {
                this.recipe.add("ingredients", (JsonElement)new JsonArray());
            }
            this.recipe.getAsJsonArray("ingredients").add((JsonElement)SizedIngredient.NESTED_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SizedIngredient.of((ItemLike)item, (int)count)).getOrThrow());
            return (Builder)this.getThis();
        }

        public Builder ingredients(TagKey<Item> tag, int count) {
            if (!this.recipe.has("ingredients")) {
                this.recipe.add("ingredients", (JsonElement)new JsonArray());
            }
            this.recipe.getAsJsonArray("ingredients").add((JsonElement)SizedIngredient.NESTED_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SizedIngredient.of(tag, (int)count)).getOrThrow());
            this.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(tag.location().toString())));
            return (Builder)this.getThis();
        }

        public Builder ingredients(TagKey<Item> tag) {
            if (!this.recipe.has("ingredients")) {
                this.recipe.add("ingredients", (JsonElement)new JsonArray());
            }
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", tag.location().toString());
            this.recipe.getAsJsonArray("ingredients").add((JsonElement)jsonobject);
            this.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(tag.location().toString())));
            return (Builder)this.getThis();
        }
    }
}

