/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class DistillationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public DistillationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "distillation");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.STONES, 10);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.SANDSTONE_BLOCKS, 10);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.STONE_BRICKS, 10);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.COBBLESTONES, 10);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.GRAVELS, 15);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.DIRT, 25);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.SANDS, 15);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.GLASS_BLOCKS, 10);
        this.makeMercuryShardRecipe(5, ItemTagRegistry.LOW_MERCURY_ORES, 1);
        this.makeMercuryShardRecipe(25, ItemTagRegistry.MEDIUM_MERCURY_ORES, 1);
        this.makeMercuryShardRecipe(50, ItemTagRegistry.HIGH_MERCURY_ORES, 1);
        this.makeMercuryShardRecipe(1, ItemTagRegistry.LOW_MERCURY_RAW_MATERIALS, 1);
        this.makeMercuryShardRecipe(5, ItemTagRegistry.MEDIUM_MERCURY_RAW_MATERIALS, 1);
        this.makeMercuryShardRecipe(10, ItemTagRegistry.HIGH_MERCURY_RAW_MATERIALS, 1);
        this.makeMercuryShardRecipe(1, ItemTagRegistry.LOW_MERCURY_METALS, 1);
        this.makeMercuryShardRecipe(5, ItemTagRegistry.MEDIUM_MERCURY_METALS, 1);
        this.makeMercuryShardRecipe(10, ItemTagRegistry.HIGH_MERCURY_METALS, 1);
        this.makeMercuryShardRecipe(1, ItemTagRegistry.LOW_MERCURY_GEMS, 1);
        this.makeMercuryShardRecipe(5, ItemTagRegistry.MEDIUM_MERCURY_GEMS, 1);
        this.makeMercuryShardRecipe(10, ItemTagRegistry.HIGH_MERCURY_GEMS, 1);
        this.makeMercuryShardRecipe(1, ItemTagRegistry.LOW_MERCURY_OTHER_MINERALS, 1);
        this.makeMercuryShardRecipe(5, ItemTagRegistry.MEDIUM_MERCURY_OTHER_MINERALS, 1);
        this.makeMercuryShardRecipe(10, ItemTagRegistry.HIGH_MERCURY_OTHER_MINERALS, 1);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.CROPS, 3);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)Tags.Items.DYES, 3);
        this.makeMercuryShardRecipe(1, Items.PORKCHOP, 2);
        this.makeMercuryShardRecipe(1, Items.COOKED_PORKCHOP, 1);
        this.makeMercuryShardRecipe(1, Items.BEEF, 2);
        this.makeMercuryShardRecipe(1, Items.COOKED_BEEF, 1);
        this.makeMercuryShardRecipe(1, Items.CHICKEN, 2);
        this.makeMercuryShardRecipe(1, Items.COOKED_CHICKEN, 1);
        this.makeMercuryShardRecipe(1, Items.COD, 2);
        this.makeMercuryShardRecipe(1, Items.COOKED_COD, 1);
        this.makeMercuryShardRecipe(1, Items.SALMON, 2);
        this.makeMercuryShardRecipe(1, Items.COOKED_SALMON, 1);
        this.makeMercuryShardRecipe(1, Items.RABBIT, 2);
        this.makeMercuryShardRecipe(1, Items.COOKED_RABBIT, 1);
        this.makeMercuryShardRecipe(1, Items.BREAD, 1);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.FLOWERS, 3);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.SAPLINGS, 3);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.LEAVES, 5);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.LOGS, 2);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.PLANKS, 8);
        this.makeMercuryShardRecipe(1, (TagKey<Item>)ItemTags.WOOL, 1);
    }

    public void makeMercuryShardRecipe(int resultCount, TagKey<Item> ingredient, int ingredientCount) {
        this.makeMercuryShardRecipe(resultCount, ingredient, ingredientCount, 100);
    }

    public void makeMercuryShardRecipe(int resultCount, TagKey<Item> ingredient, int ingredientCount, int distillationTime) {
        this.makeMercuryShardRecipe(ingredient.location().getPath().replace("/", "."), resultCount, ingredient, ingredientCount, distillationTime);
    }

    public void makeMercuryShardRecipe(String recipeName, int resultCount, TagKey<Item> ingredient, int ingredientCount, int distillationTime) {
        this.recipeConsumer.accept(this.modLoc(recipeName), ((Builder)((Builder)new Builder(new ItemStack((ItemLike)ItemRegistry.MERCURY_SHARD.get(), resultCount)).sizedIngredient(ingredient, ingredientCount)).time(distillationTime)).build());
    }

    public void makeMercuryShardRecipe(int resultCount, Item ingredient, int ingredientCount) {
        this.makeMercuryShardRecipe(resultCount, ingredient, ingredientCount, 100);
    }

    public void makeMercuryShardRecipe(int resultCount, Item ingredient, int ingredientCount, int distillationTime) {
        this.makeMercuryShardRecipe(BuiltInRegistries.ITEM.getKey((Object)ingredient).getPath(), resultCount, ingredient, ingredientCount, distillationTime);
    }

    public void makeMercuryShardRecipe(String recipeName, int resultCount, Item ingredient, int ingredientCount, int distillationTime) {
        this.recipeConsumer.accept(this.modLoc(recipeName), ((Builder)((Builder)new Builder(new ItemStack((ItemLike)ItemRegistry.MERCURY_SHARD.get(), resultCount)).sizedIngredient((ItemLike)ingredient, ingredientCount)).time(distillationTime)).build());
    }

    public String getName() {
        return "Distillation Recipes";
    }

    protected static class Builder
    extends JsonRecipeProvider.RecipeBuilder<Builder> {
        protected Builder(ItemStack result) {
            super((Holder<RecipeType<?>>)RecipeTypeRegistry.DISTILLATION);
            this.result(result);
            this.time(100);
        }
    }
}

