/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.FluidRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class DigestionRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 200;

    public DigestionRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "digestion");
    }

    public void makeTierConversion(AlchemicalSulfurItem lower, AlchemicalSulfurItem higher, int conversionFactor, int salAmmoniacAmount) {
        this.makeRecipe((Fluid)FluidRegistry.SAL_AMMONIAC.get(), salAmmoniacAmount, List.of(Pair.of((Object)((Object)lower), (Object)conversionFactor), Pair.of((Object)((Item)ItemRegistry.PURIFIED_GOLD.get()), (Object)1)), higher, 1, 1000, "_from_" + lower.tier().name().toLowerCase());
        this.makeRecipe((Fluid)FluidRegistry.SAL_AMMONIAC.get(), salAmmoniacAmount, List.of(Pair.of((Object)((Object)higher), (Object)1)), lower, conversionFactor, 1000, "_from_" + higher.tier().name().toLowerCase());
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipeWithTags((Fluid)Fluids.WATER, 1000, List.of(Tags.Items.INGOTS_GOLD, ItemTagRegistry.ALCHEMICAL_SALTS), (Item)ItemRegistry.PURIFIED_GOLD.get(), 20, 1000);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_ABUNDANT.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_COMMON.get()), 4, 10);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_COMMON.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_RARE.get()), 4, 15);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_RARE.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_PRECIOUS.get()), 4, 50);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_ABUNDANT.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_COMMON.get()), 4, 10);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_COMMON.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_RARE.get()), 4, 15);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_RARE.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_PRECIOUS.get()), 4, 50);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_ABUNDANT.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_COMMON.get()), 4, 10);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_COMMON.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_RARE.get()), 4, 15);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_RARE.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_PRECIOUS.get()), 4, 50);
    }

    public void makeRecipe(Fluid fluid, int fluidAmount, List<Pair<Item, Integer>> ingredients, Item result, int resultCount, int time, String postFix) {
        this.makeRecipe(this.name((ItemLike)result) + postFix, fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipe(Fluid fluid, int fluidAmount, List<Pair<Item, Integer>> ingredients, Item result, int resultCount, int time) {
        this.makeRecipe(this.name((ItemLike)result), fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipe(String name, Fluid fluid, int fluidAmount, List<Pair<Item, Integer>> ingredients, Item result, int resultCount, int time) {
        Builder recipe = (Builder)new Builder(new ItemStack((ItemLike)result, resultCount)).fluid(fluid, fluidAmount).time(time);
        ingredients.forEach(i -> recipe.ingredients((ItemLike)i.getFirst(), (int)((Integer)i.getSecond())));
        this.recipeConsumer.accept(this.modLoc(name), recipe.build());
    }

    public void makeRecipeWithTags(Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time) {
        this.makeRecipeWithTags(this.name((ItemLike)result), fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipeWithTags(String name, Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time) {
        Builder recipe = (Builder)new Builder(new ItemStack((ItemLike)result, resultCount)).fluid(fluid, fluidAmount).time(time);
        ingredients.forEach(i -> recipe.ingredients((TagKey<Item>)i, 1));
        this.recipeConsumer.accept(this.modLoc(name), recipe.build());
    }

    public String getName() {
        return "Digestion Recipes";
    }

    protected static class Builder
    extends JsonRecipeProvider.RecipeBuilder<Builder> {
        protected Builder(ItemStack result) {
            super((Holder<RecipeType<?>>)RecipeTypeRegistry.DIGESTION);
            this.result(result);
            this.time(200);
        }

        public Builder fluid(TagKey<Fluid> tag, int amount) {
            return (Builder)this.sizedFluidIngredient("fluid", tag, amount);
        }

        public Builder fluid(Fluid fluid, int amount) {
            return (Builder)this.sizedFluidIngredient("fluid", fluid, amount);
        }

        public Builder ingredients(ItemLike item) {
            return this.ingredients(item, 1);
        }

        public Builder ingredients(ItemLike item, int count) {
            if (!this.recipe.has("ingredients")) {
                this.recipe.add("ingredients", (JsonElement)new JsonArray());
            }
            this.recipe.getAsJsonArray("ingredients").add((JsonElement)SizedIngredient.NESTED_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SizedIngredient.of((ItemLike)item, (int)count)).getOrThrow());
            return (Builder)this.getThis();
        }

        public Builder ingredients(TagKey<Item> tag, int count) {
            if (!this.recipe.has("ingredients")) {
                this.recipe.add("ingredients", (JsonElement)new JsonArray());
            }
            this.recipe.getAsJsonArray("ingredients").add((JsonElement)SizedIngredient.NESTED_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SizedIngredient.of(tag, (int)count)).getOrThrow());
            this.condition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(tag.location().toString())));
            return (Builder)this.getThis();
        }
    }
}

