/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SaltRegistry;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class CalcinationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public CalcinationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "calcination");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipe("_from_stone", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((TagKey<Item>)Tags.Items.STONES));
        this.makeRecipe("_from_sandstone", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((TagKey<Item>)Tags.Items.SANDSTONE_BLOCKS));
        this.makeRecipe("_from_cobblestone", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((TagKey<Item>)Tags.Items.COBBLESTONES));
        this.makeRecipe("_from_dirt", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((TagKey<Item>)ItemTags.DIRT));
        this.makeRecipe("_from_sand", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((TagKey<Item>)ItemTags.SAND));
        this.makeRecipe("_from_gravel", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((ItemLike)Items.GRAVEL));
        this.makeRecipe("_from_clay", new Builder((ItemLike)SaltRegistry.STRATA, 4).sizedIngredient((ItemLike)Items.CLAY));
        this.makeRecipe("_from_clay_ball", new Builder((ItemLike)SaltRegistry.STRATA).sizedIngredient((ItemLike)Items.CLAY_BALL));
        this.makeRecipe("_from_ores", new Builder((ItemLike)SaltRegistry.MINERAL).sizedIngredient((TagKey<Item>)Tags.Items.ORES));
        this.makeRecipe("_from_raw_materials", new Builder((ItemLike)SaltRegistry.MINERAL).sizedIngredient((TagKey<Item>)Tags.Items.RAW_MATERIALS));
        this.makeRecipe("_from_ingots", new Builder((ItemLike)SaltRegistry.MINERAL, 2).sizedIngredient((TagKey<Item>)Tags.Items.INGOTS));
        this.makeRecipe("_from_gems", new Builder((ItemLike)SaltRegistry.MINERAL, 2).sizedIngredient((TagKey<Item>)Tags.Items.GEMS));
        this.makeRecipe("_from_other_minerals", new Builder((ItemLike)SaltRegistry.MINERAL, 2).sizedIngredient(ItemTagRegistry.OTHER_MINERALS));
        this.makeRecipe("", (Builder)new Builder((ItemLike)SaltRegistry.MINERAL).sizedIngredient((ItemLike)SaltRegistry.STRATA.get(), 20));
        this.makeRecipe("", new Builder((ItemLike)SaltRegistry.CROPS).sizedIngredient((TagKey<Item>)Tags.Items.CROPS));
    }

    protected void makeRecipe(String suffix, Builder recipe) {
        this.recipeConsumer.accept(this.modLoc(this.name(recipe.result()) + suffix), recipe.build());
    }

    public String getName() {
        return "Calcination Recipes";
    }

    protected static class Builder
    extends JsonRecipeProvider.RecipeBuilder<Builder> {
        private final ItemStack result;

        protected Builder(ItemLike result) {
            this(result, 1);
        }

        protected Builder(ItemLike result, int count) {
            this(new ItemStack(result, count));
        }

        protected Builder(ItemStack result) {
            super((Holder<RecipeType<?>>)RecipeTypeRegistry.CALCINATION);
            this.result(result);
            this.time(100);
            this.result = result;
        }

        public ItemStack result() {
            return this.result;
        }

        public Builder sizedIngredient(TagKey<Item> tag) {
            return (Builder)super.sizedIngredient(tag, 1);
        }

        public Builder sizedIngredient(ItemLike item) {
            return (Builder)super.sizedIngredient(item, 1);
        }
    }
}

