/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.FluidRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class AccumulationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public AccumulationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "accumulation");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        Fluid salAmmoniac = (Fluid)FluidRegistry.SAL_AMMONIAC.get();
        this.makeRecipe("sal_ammoniac_from_water", (Builder)new Builder(new FluidStack(salAmmoniac, 100)).evaporant((TagKey<Fluid>)FluidTags.WATER, 1000).time(100));
        this.makeRecipe("sal_ammoniac_from_water_and_sal_ammoniac_crystal", (Builder)new Builder(new FluidStack(salAmmoniac, 1000)).evaporant((TagKey<Fluid>)FluidTags.WATER, 1000).solute(ItemTagRegistry.GEMS_SAL_AMMONIAC).time(100));
    }

    protected void makeRecipe(String name, Builder recipe) {
        this.recipeConsumer.accept(this.modLoc(name), recipe.build());
    }

    public String getName() {
        return "Accumulation Recipes";
    }

    protected static class Builder
    extends JsonRecipeProvider.RecipeBuilder<Builder> {
        protected Builder(FluidStack result) {
            super((Holder<RecipeType<?>>)RecipeTypeRegistry.ACCUMULATION);
            this.result(result);
        }

        public Builder evaporant(TagKey<Fluid> tag, int amount) {
            return (Builder)this.sizedFluidIngredient("evaporant", tag, amount);
        }

        public Builder solute(TagKey<Item> tag) {
            return (Builder)this.ingredient("solute", tag);
        }
    }
}

