/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.model;

import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorBlock;
import com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.LiquefactionCauldronBlock;
import com.klikli_dev.theurgy.content.apparatus.logisticsitemconnector.LogisticsItemConnectorBlock;
import com.klikli_dev.theurgy.content.apparatus.logisticsitemconnector.extractor.LogisticsItemExtractorBlock;
import com.klikli_dev.theurgy.content.apparatus.logisticsitemconnector.inserter.LogisticsItemInserterBlock;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class TheurgyBlockStateProvider
extends BlockStateProvider {
    public TheurgyBlockStateProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "theurgy", exFileHelper);
    }

    protected ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    protected void registerStatesAndModels() {
        this.registerCalcinationOven();
        this.registerPyromanticBrazier();
        this.registerLiquefactionCauldron();
        this.registerDistiller();
        this.registerIncubator();
        this.registerIncubatorVessels();
        this.registerSalAmmoniacAccumulator();
        this.registerSalAmmoniacTank();
        this.registerMercuryCatalyst();
        this.registerCaloricFluxEmitter();
        this.registerSulfuricFluxEmitter();
        this.registerReformationSourcePedestal();
        this.registerReformationTargetPedestal();
        this.registerReformationResultPedestal();
        this.registerFermentationVat();
        this.registerDigestionVat();
        ModelFile filter = this.makeLogisticsFilterModel();
        this.registerLogisticsItemInserter(filter);
        this.registerLogisticsItemExtractor(filter);
        this.registerLogisticsNode();
        this.simpleBlockWithItem((Block)BlockRegistry.SAL_AMMONIAC_ORE.get(), this.cubeAll((Block)BlockRegistry.SAL_AMMONIAC_ORE.get()));
        this.simpleBlockWithItem((Block)BlockRegistry.DEEPSLATE_SAL_AMMONIAC_ORE.get(), this.cubeAll((Block)BlockRegistry.DEEPSLATE_SAL_AMMONIAC_ORE.get()));
    }

    protected ModelFile makeLogisticsFilterModel() {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("logistics_connector_filter", this.modLoc("block/logistics_connector_filter_template"))).ao(false)).texture("texture", this.modLoc("block/logistics_connector_filter"))).texture("particle", this.mcLoc("block/iron_block"));
    }

    protected void registerLogisticsItemInserter(ModelFile filter) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("logistics_item_inserter", this.modLoc("block/logistics_connector_template"))).ao(false)).texture("texture", this.modLoc("block/logistics_inserter"))).texture("particle", this.mcLoc("block/copper_block"));
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)BlockRegistry.LOGISTICS_ITEM_INSERTER.get());
        int angleOffset = 180;
        for (BlockState state : ((LogisticsItemInserterBlock)BlockRegistry.LOGISTICS_ITEM_INSERTER.get()).getStateDefinition().getPossibleStates()) {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(filter).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + angleOffset) % 360).addModel()).condition((Property)BlockStateProperties.FACING, (Comparable[])new Direction[]{dir}).condition((Property)LogisticsItemConnectorBlock.HAS_FILTER, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + angleOffset) % 360).addModel()).condition((Property)BlockStateProperties.FACING, (Comparable[])new Direction[]{dir}).end();
        }
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key((Block)BlockRegistry.LOGISTICS_ITEM_INSERTER.get()).getPath())).parent((ModelFile)model)).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, 4.0f, 0.0f).scale(1.0f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 5.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end();
    }

    protected void registerLogisticsItemExtractor(ModelFile filter) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("logistics_item_extractor", this.modLoc("block/logistics_connector_template"))).ao(false)).texture("texture", this.modLoc("block/logistics_extractor"))).texture("particle", this.mcLoc("block/copper_block"));
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)BlockRegistry.LOGISTICS_ITEM_EXTRACTOR.get());
        int angleOffset = 180;
        for (BlockState state : ((LogisticsItemExtractorBlock)BlockRegistry.LOGISTICS_ITEM_EXTRACTOR.get()).getStateDefinition().getPossibleStates()) {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(filter).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + angleOffset) % 360).addModel()).condition((Property)BlockStateProperties.FACING, (Comparable[])new Direction[]{dir}).condition((Property)LogisticsItemConnectorBlock.HAS_FILTER, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + angleOffset) % 360).addModel()).condition((Property)BlockStateProperties.FACING, (Comparable[])new Direction[]{dir}).end();
        }
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key((Block)BlockRegistry.LOGISTICS_ITEM_EXTRACTOR.get()).getPath())).parent((ModelFile)model)).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, 4.0f, 0.0f).scale(1.0f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 5.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end();
    }

    protected void registerLogisticsNode() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("logistics_connection_node", this.modLoc("block/logistics_node_template"))).ao(false)).texture("connector", this.modLoc("block/logistics_node_connector"))).texture("base", this.modLoc("block/logistics_node_base"))).texture("particle", this.mcLoc("block/terracotta"));
        this.directionalBlock((Block)BlockRegistry.LOGISTICS_CONNECTION_NODE.get(), (ModelFile)model);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key((Block)BlockRegistry.LOGISTICS_CONNECTION_NODE.get()).getPath())).parent((ModelFile)model)).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, 4.0f, 0.0f).scale(1.0f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 5.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).translation(0.0f, 6.0f, 0.0f).scale(0.7f).end();
    }

    protected void registerFermentationVat() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fermentation_vat", this.mcLoc("block/cube_bottom_top"))).texture("bottom", this.modLoc("block/fermentation_vat_bottom"))).texture("side", this.modLoc("block/fermentation_vat_side"))).texture("top", this.modLoc("block/fermentation_vat_top"))).texture("particle", this.modLoc("block/fermentation_vat_top"));
        BlockModelBuilder modelOpen = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fermentation_vat_open", this.mcLoc("block/cube_bottom_top"))).texture("bottom", this.modLoc("block/fermentation_vat_bottom"))).texture("side", this.modLoc("block/fermentation_vat_side"))).texture("top", this.modLoc("block/fermentation_vat_top_open"))).texture("particle", this.modLoc("block/fermentation_vat_top"));
        this.directionalBlock((Block)BlockRegistry.FERMENTATION_VAT.get(), state -> (Boolean)state.getValue((Property)BlockStateProperties.OPEN) != false ? modelOpen : model);
        this.simpleBlockItem((Block)BlockRegistry.FERMENTATION_VAT.get(), (ModelFile)model);
    }

    protected void registerDigestionVat() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("digestion_vat")).texture("particle", "minecraft:block/blue_terracotta");
        this.simpleBlock((Block)BlockRegistry.DIGESTION_VAT.get(), (ModelFile)model);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("digestion_vat")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 45.0f, 0.0f).translation(0.0f, -1.0f, 0.0f).scale(0.55f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 1.0f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 90.0f, 0.0f).translation(0.0f, 2.0f, 0.5f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 90.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 270.0f, 0.0f).translation(0.0f, 2.0f, 0.5f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 270.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.HEAD).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 16.0f, 0.0f).scale(1.5f).end();
    }

    protected void registerReformationSourcePedestal() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("reformation_source_pedestal", this.modLoc("block/reformation_source_pedestal_template"))).ao(false)).texture("texture", this.modLoc("block/reformation_source_pedestal"))).texture("particle", this.mcLoc("block/copper_block"));
        this.simpleBlockWithItem((Block)BlockRegistry.REFORMATION_SOURCE_PEDESTAL.get(), (ModelFile)model);
    }

    protected void registerReformationTargetPedestal() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("reformation_target_pedestal", this.modLoc("block/reformation_target_pedestal_template"))).ao(false)).texture("texture", this.modLoc("block/reformation_target_pedestal"))).texture("particle", this.mcLoc("block/copper_block"));
        this.simpleBlockWithItem((Block)BlockRegistry.REFORMATION_TARGET_PEDESTAL.get(), (ModelFile)model);
    }

    protected void registerReformationResultPedestal() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("reformation_result_pedestal", this.modLoc("block/reformation_result_pedestal_template"))).ao(false)).texture("texture", this.modLoc("block/reformation_result_pedestal"))).texture("particle", this.mcLoc("block/copper_block"));
        this.simpleBlockWithItem((Block)BlockRegistry.REFORMATION_RESULT_PEDESTAL.get(), (ModelFile)model);
    }

    protected void registerCaloricFluxEmitter() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("caloric_flux_emitter", this.modLoc("block/caloric_flux_emitter_template"))).ao(false)).renderType(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"translucent"))).texture("emitter", this.modLoc("block/caloric_flux_emitter"))).texture("socket", this.modLoc("block/emitter_socket"))).texture("particle", this.modLoc("block/emitter_socket"));
        this.directionalBlock((Block)BlockRegistry.CALORIC_FLUX_EMITTER.get(), (ModelFile)model);
        this.simpleBlockItem((Block)BlockRegistry.CALORIC_FLUX_EMITTER.get(), (ModelFile)model);
    }

    protected void registerSulfuricFluxEmitter() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("sulfuric_flux_emitter", this.modLoc("block/sulfuric_flux_emitter_template"))).ao(false)).renderType(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"translucent"))).texture("emitter", this.modLoc("block/sulfuric_flux_emitter"))).texture("socket", this.modLoc("block/emitter_socket"))).texture("particle", this.modLoc("block/emitter_socket"));
        this.directionalBlock((Block)BlockRegistry.SULFURIC_FLUX_EMITTER.get(), (ModelFile)model);
        this.simpleBlockItem((Block)BlockRegistry.SULFURIC_FLUX_EMITTER.get(), (ModelFile)model);
    }

    protected void registerSalAmmoniacAccumulator() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("sal_ammoniac_accumulator")).texture("particle", "minecraft:block/copper_block");
        this.simpleBlock((Block)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR.get(), (ModelFile)model);
        ((ItemModelBuilder)this.itemModels().getBuilder("sal_ammoniac_accumulator")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
    }

    protected void registerSalAmmoniacTank() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("sal_ammoniac_tank")).texture("particle", "minecraft:block/copper_block");
        this.simpleBlock((Block)BlockRegistry.SAL_AMMONIAC_TANK.get(), (ModelFile)model);
        ((ItemModelBuilder)this.itemModels().getBuilder("sal_ammoniac_tank")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
    }

    protected void registerMercuryCatalyst() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("mercury_catalyst", this.modLoc("block/mercury_catalyst_template"))).ao(false)).renderType(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"translucent"))).texture("texture", this.modLoc("block/mercury_catalyst"))).texture("particle", this.mcLoc("block/iron_block"));
        this.simpleBlockWithItem((Block)BlockRegistry.MERCURY_CATALYST.get(), (ModelFile)model);
    }

    protected void registerDistiller() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("distiller")).texture("particle", "minecraft:block/copper_block");
        this.getVariantBuilder((Block)BlockRegistry.DISTILLER.get()).forAllStates(s -> ConfiguredModel.builder().modelFile((ModelFile)model).build());
        ((ItemModelBuilder)this.itemModels().getBuilder("distiller")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
    }

    protected void registerIncubator() {
        BlockModelBuilder lowerHalfModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("incubator_lower", this.modLoc("block/incubator_template"))).ao(false)).texture("texture", this.modLoc("block/incubator_gold"))).texture("particle", this.mcLoc("block/copper_block"));
        BlockModelBuilder upperHalfModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("incubator_upper")).ao(false)).texture("particle", "minecraft:block/copper_block");
        BlockModelBuilder pipeModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("incubator_pipe", this.modLoc("block/incubator_pipe_template"))).ao(false)).texture("texture", this.modLoc("block/incubator_pipe"))).texture("particle", this.mcLoc("block/copper_block"));
        MultiPartBlockStateBuilder incubatorBuilder = this.getMultipartBuilder((Block)BlockRegistry.INCUBATOR.get());
        ((MultiPartBlockStateBuilder.PartBuilder)incubatorBuilder.part().modelFile((ModelFile)lowerHalfModel).addModel()).condition(IncubatorBlock.HALF, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.LOWER}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)incubatorBuilder.part().modelFile((ModelFile)upperHalfModel).addModel()).condition(IncubatorBlock.HALF, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.UPPER}).end();
        PipeBlock.PROPERTY_BY_DIRECTION.entrySet().forEach(e -> {
            Direction dir = (Direction)e.getKey();
            if (dir.getAxis().isHorizontal()) {
                ((MultiPartBlockStateBuilder.PartBuilder)incubatorBuilder.part().modelFile((ModelFile)pipeModel).rotationY(((int)dir.toYRot() + 180) % 360).uvLock(true).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true}).condition(IncubatorBlock.HALF, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.LOWER});
            }
        });
        ((ItemModelBuilder)this.itemModels().withExistingParent("incubator", lowerHalfModel.getLocation())).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, -2.0f, 0.0f).scale(0.35f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 225.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end();
    }

    protected void registerIncubatorVessels() {
        BlockModelBuilder incubatorVessel = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("incubator_vessel")).texture("particle", "minecraft:block/copper_block");
        this.simpleBlock((Block)BlockRegistry.INCUBATOR_MERCURY_VESSEL.get(), (ModelFile)incubatorVessel);
        this.simpleBlock((Block)BlockRegistry.INCUBATOR_SALT_VESSEL.get(), (ModelFile)incubatorVessel);
        this.simpleBlock((Block)BlockRegistry.INCUBATOR_SULFUR_VESSEL.get(), (ModelFile)incubatorVessel);
        ((ItemModelBuilder)this.itemModels().getBuilder("incubator_mercury_vessel")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
        ((ItemModelBuilder)this.itemModels().getBuilder("incubator_salt_vessel")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
        ((ItemModelBuilder)this.itemModels().getBuilder("incubator_sulfur_vessel")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
    }

    protected void registerLiquefactionCauldron() {
        BlockModelBuilder lowerHalfModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("liquefaction_cauldron_lower", this.modLoc("block/liquefaction_cauldron_template"))).ao(false)).texture("texture", this.modLoc("block/liquefaction_cauldron"))).texture("particle", this.mcLoc("block/copper_block"));
        BlockModelBuilder upperHalfModel = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("liquefaction_cauldron_upper")).texture("particle", "minecraft:block/copper_block");
        this.getVariantBuilder((Block)BlockRegistry.LIQUEFACTION_CAULDRON.get()).forAllStates(s -> {
            BlockModelBuilder model = s.getValue(LiquefactionCauldronBlock.HALF) == DoubleBlockHalf.LOWER ? lowerHalfModel : upperHalfModel;
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
        ((ItemModelBuilder)this.itemModels().withExistingParent("liquefaction_cauldron", lowerHalfModel.getLocation())).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, -2.0f, 0.0f).scale(0.5f).end();
    }

    protected void registerCalcinationOven() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("calcination_oven")).texture("particle", "minecraft:block/copper_block");
        this.getVariantBuilder((Block)BlockRegistry.CALCINATION_OVEN.get()).forAllStates(s -> ConfiguredModel.builder().modelFile((ModelFile)model).build());
        ((ItemModelBuilder)this.itemModels().getBuilder("calcination_oven")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
    }

    protected void registerPyromanticBrazier() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pyromantic_brazier", this.modLoc("block/pyromantic_brazier_template"))).ao(false)).texture("texture", this.modLoc("block/pyromantic_brazier"))).texture("particle", this.mcLoc("block/copper_block"));
        BlockModelBuilder modelLit = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pyromantic_brazier_lit", this.modLoc("block/pyromantic_brazier_lit_template"))).renderType("cutout_mipped")).texture("texture", this.modLoc("block/pyromantic_brazier_lit"))).texture("particle", this.mcLoc("block/copper_block"))).texture("fire", this.mcLoc("block/campfire_fire"));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)BlockRegistry.PYROMANTIC_BRAZIER.get()).partialState().with((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelLit).addModel();
        ((ItemModelBuilder)this.itemModels().withExistingParent("pyromantic_brazier", this.modLoc("block/pyromantic_brazier"))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).scale(0.5f).end();
    }
}

