/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.loot;

import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class TheurgyBlockLootSubProvider
extends BlockLootSubProvider {
    public TheurgyBlockLootSubProvider(HolderLookup.Provider pRegistries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), pRegistries);
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> pGenerator) {
        this.generate();
        this.map.forEach(pGenerator);
    }

    protected void generate() {
        this.dropSelf((Block)BlockRegistry.PYROMANTIC_BRAZIER.get());
        this.dropDoubleBlockOnce((Block)BlockRegistry.CALCINATION_OVEN.get());
        this.dropDoubleBlockOnce((Block)BlockRegistry.LIQUEFACTION_CAULDRON.get());
        this.dropDoubleBlockOnce((Block)BlockRegistry.DISTILLER.get());
        this.dropDoubleBlockOnce((Block)BlockRegistry.INCUBATOR.get());
        this.dropSelf((Block)BlockRegistry.INCUBATOR_MERCURY_VESSEL.get());
        this.dropSelf((Block)BlockRegistry.INCUBATOR_SULFUR_VESSEL.get());
        this.dropSelf((Block)BlockRegistry.INCUBATOR_SALT_VESSEL.get());
        this.dropSelf((Block)BlockRegistry.SAL_AMMONIAC_ACCUMULATOR.get());
        this.dropSelf((Block)BlockRegistry.SAL_AMMONIAC_TANK.get());
        this.dropSelfWithComponents((Block)BlockRegistry.MERCURY_CATALYST.get(), (DataComponentType)DataComponentRegistry.MERCURY_FLUX_STORAGE.get(), (DataComponentType)DataComponentRegistry.MERCURY_FLUX_TO_CONVERT.get(), (DataComponentType)DataComponentRegistry.CURRENT_MERCURY_FLUX_PER_TICK.get(), (DataComponentType)DataComponentRegistry.MERCURY_CATALYST_INVENTORY.get());
        this.dropSelfWithComponents((Block)BlockRegistry.CALORIC_FLUX_EMITTER.get(), (DataComponentType)DataComponentRegistry.MERCURY_FLUX_STORAGE.get());
        this.dropSelfWithComponents((Block)BlockRegistry.SULFURIC_FLUX_EMITTER.get(), (DataComponentType)DataComponentRegistry.MERCURY_FLUX_STORAGE.get());
        this.dropSelf((Block)BlockRegistry.REFORMATION_SOURCE_PEDESTAL.get());
        this.dropSelf((Block)BlockRegistry.REFORMATION_TARGET_PEDESTAL.get());
        this.dropSelf((Block)BlockRegistry.REFORMATION_RESULT_PEDESTAL.get());
        this.dropSelf((Block)BlockRegistry.FERMENTATION_VAT.get());
        this.dropSelf((Block)BlockRegistry.DIGESTION_VAT.get());
        this.dropSelf((Block)BlockRegistry.LOGISTICS_ITEM_EXTRACTOR.get());
        this.dropSelf((Block)BlockRegistry.LOGISTICS_ITEM_INSERTER.get());
        this.dropSelf((Block)BlockRegistry.LOGISTICS_CONNECTION_NODE.get());
        this.add((Block)BlockRegistry.SAL_AMMONIAC_ORE.get(), block -> this.createOreDrop((Block)block, (Item)ItemRegistry.SAL_AMMONIAC_CRYSTAL.get()));
        this.add((Block)BlockRegistry.DEEPSLATE_SAL_AMMONIAC_ORE.get(), block -> this.createOreDrop((Block)block, (Item)ItemRegistry.SAL_AMMONIAC_CRYSTAL.get()));
    }

    protected void dropDoubleBlockOnce(Block pBlock) {
        this.add(pBlock, this.createSinglePropConditionTable(pBlock, (Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected final void dropSelfWithComponents(Block pBlock, DataComponentType<?> ... pIncludes) {
        this.add(pBlock, this.createSelfWithComponentsDrop(pBlock, this.copyComponents(pIncludes)));
    }

    protected void dropSelfWithComponents(Block pBlock, CopyComponentsFunction.Builder data) {
        this.add(pBlock, this.createSelfWithComponentsDrop(pBlock, data));
    }

    protected LootTable.Builder createSelfWithComponentsDrop(Block pBlock, CopyComponentsFunction.Builder data) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)pBlock, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pBlock).apply((LootItemFunction.Builder)data))));
    }

    protected CopyComponentsFunction.Builder copyComponents(DataComponentType<?> ... pIncludes) {
        CopyComponentsFunction.Builder builder = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY);
        for (DataComponentType<?> include : pIncludes) {
            builder.include(include);
        }
        return builder;
    }
}

