/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.logistics;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ItemInserterEntry
extends EntryProvider {
    public ItemInserterEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("inserter", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LOGISTICS_ITEM_INSERTER.get()})).withText(this.context().pageText()));
        this.pageText("When attached to a block, the inserter will insert items from the Mercurial Logistics System into the block. The items will be extracted from blocks that have extractors attached to them, if the extractors are part of the same network.\n");
        this.page("recipe", () -> (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/logistics_item_inserter")));
        this.page("usage", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Usage");
        this.pageText("Right-click a block that has an inventory to attach the inserter to it.\n\\\n\\\nThe inserter will by default insert into the face it is attached to. E.g. if it is attached to the side of a furnace, it will insert into the fuel slot.\n");
        this.page("identification", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Identification");
        this.pageText("The inserter features a green band on the side attached to the target block.\n");
        this.page("direction", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Changing Direction");
        this.pageText("Inserters can also insert into faces they are not attached to. Use the {0} in the \"Select Direction\" mode to cycle through the insert directions.\\\nE.g. an inserter attached to the top of a furnace can be configured to insert fuel into furnace from the side (instead of into the input slot from the top).\n", new Object[]{this.entryLink("Mercurial Wand", "logistics", "mercurial_wand")});
    }

    protected String entryName() {
        return "Mercurial Item Inserter";
    }

    protected String entryDescription() {
        return "Inserting items into Blocks from the Mercurial Logistics System.";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.LOGISTICS_ITEM_INSERTER.get()));
    }

    protected String entryId() {
        return "item_inserter";
    }
}

