/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.logistics;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookImagePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ConnectionNodeEntry
extends EntryProvider {
    public ConnectionNodeEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("node", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LOGISTICS_CONNECTION_NODE.get()})).withText(this.context().pageText()));
        this.pageText("The node allows connecting wires over long distances without placing an inserter or extractor.\n");
        this.page("recipe", () -> (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/logistics_connector_node")));
        this.page("usage", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Usage");
        this.pageText("1. Right-click any block to attach the node to it.\n2. Then connect the node to other blocks using wires.\n3. Any block connected directly or indirectly will be part of the same network.\n");
        this.page("image", () -> BookImagePageModel.create().withTitle(this.context().pageTitle()).withImages(new ResourceLocation[]{Theurgy.loc("textures/gui/book/connection_node_example.png")}));
        this.pageTitle("Demonstration");
        this.page("large_networks", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Complex Networks");
        this.pageText("In networks with multiple inserters and extractors the default behaviour is round-robin. That means each extractor will attempt to split the items evenly between all connected inserters.\n\\\n\\\nThis behaviour can be modified with filters (see further entries in this category). In the future more advanced routing options will be available.\n");
    }

    protected String entryName() {
        return "Mercurial Connection Node";
    }

    protected String entryDescription() {
        return "Extend the Range of Logistics Networks";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.LOGISTICS_CONNECTION_NODE.get()));
    }

    protected String entryId() {
        return "connection_node";
    }
}

