/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.datagen.book.DivinationRodEntryProvider;
import com.klikli_dev.theurgy.datagen.book.TheurgyBookProvider;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.AboutModEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.AlchemicalNiterEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.CaloricFluxEmitterEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.IntroEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.RenewableGoldEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.ReplicationEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.exaltation.ConvertToOtherTierEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.exaltation.DigestionEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.exaltation.DigestionVatEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.exaltation.FermentationEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.exaltation.PurifiedGoldEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.reformation.ConvertWithinTypeAndTierEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.reformation.IncubationEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.reformation.ReformationArrayEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.reformation.RequiredItemsEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.reformation.ResultEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.reformation.SourceEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.reformation.SulfuricFluxEmitterEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.reformation.TargetEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.spagyrics.CreateMercuryEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.spagyrics.CreateSaltEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.spagyrics.CreateSolventEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.spagyrics.CreateSulfurEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.spagyrics.NeededApparatusEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.spagyrics.OreRefiningEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.spagyrics.SpagyricsEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.spagyrics.StrataRecyclingEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.transmutation.ConvertToOtherTypeEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.transmutation.FermentationVatEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.transmutation.NiterToNiterReformationEntry;
import com.klikli_dev.theurgy.datagen.book.gettingstarted.transmutation.NiterToSulfurReformationEntry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.level.ItemLike;

public class GettingStartedCategoryProvider
extends CategoryProvider {
    public static final String CATEGORY_ID = "getting_started";

    public GettingStartedCategoryProvider(TheurgyBookProvider parent) {
        super((ModonomiconProviderBase)parent);
    }

    public TheurgyBookProvider parent() {
        return (TheurgyBookProvider)this.parent;
    }

    protected String[] generateEntryMap() {
        return new String[]{"___________________________________", "__________________\u1e0d___\u010f_\u1e11_\u1e13________", "___________________________________", "________________d___\u1e0b______________", "___________________________________", "__________________\u0111___\u0256_\u1d91__________", "___________________________________", "__________i_a_________c___\u1e5b_\u0155______", "___________________________________", "______________s_____\u1e5f_n_r_\u0213___\u0157_\u0280_\u0211", "___________________________________", "______________o_____________\u0159______", "___________________________________", "______________\u00f3___________\u021b________", "___________________________________", "____________\u0151_\u00f2_________\u0165_\u0163_\u01ad_\u0288_\u1e6b_\u1e6d", "___________________________________", "____________\u00f6___\u00f4_\u01a1_______\u00ea_\u011b______", "___________________________________", "______________\u00f5_________\u00e9_\u00e8_\u00eb_\u0113_\u0117_\u0119", "___________________________________", "________________________\u0192__________"};
    }

    protected void generateEntries() {
        BookEntryModel introEntry = new IntroEntry(this).generate('i');
        BookEntryModel aboutModEntry = new AboutModEntry(this).generate('a');
        aboutModEntry.withParent(introEntry);
        this.generateDivinationRodEntries(aboutModEntry);
        Pair<BookEntryModel, BookEntryModel> spagyrics = this.generateSpagyricsEntries(aboutModEntry);
        BookEntryModel replication = new ReplicationEntry(this).generate('\u1e5f');
        replication.withParent((BookEntryModel)spagyrics.getFirst());
        replication.withParent((BookEntryModel)spagyrics.getSecond());
        replication.withCondition((BookConditionModel)this.condition().entryRead((BookEntryModel)spagyrics.getSecond()));
        replication.showWhenAnyParentUnlocked(true);
        BookEntryModel niter = new AlchemicalNiterEntry(this).generate('n');
        niter.withParent(replication);
        BookEntryModel caloricFlux = new CaloricFluxEmitterEntry(this).generate('c');
        caloricFlux.withParent(niter);
        Pair<BookEntryModel, BookEntryModel> reformation = this.generateReformationEntries(niter);
        Pair<BookEntryModel, BookEntryModel> transmutation = this.generateTransmutationEntries(reformation);
        Pair<BookEntryModel, BookEntryModel> exaltation = this.generateExaltationEntries(transmutation);
        BookEntryModel renewableGold = new RenewableGoldEntry(this).generate('\u0192');
        renewableGold.withParent((BookEntryModel)exaltation.getFirst());
        renewableGold.withCondition((BookConditionModel)this.condition().entryRead((BookEntryModel)exaltation.getSecond()));
        renewableGold.hideWhileLocked(true);
    }

    protected String categoryName() {
        return "Getting Started";
    }

    protected BookIconModel categoryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.THE_HERMETICA_ICON.get()));
    }

    public String categoryId() {
        return CATEGORY_ID;
    }

    protected BookCategoryModel additionalSetup(BookCategoryModel category) {
        return super.additionalSetup(category).withBackground(Theurgy.loc("textures/gui/book/bg_nightsky.png"));
    }

    protected Pair<BookEntryModel, BookEntryModel> generateExaltationEntries(Pair<BookEntryModel, BookEntryModel> transmutation) {
        BookEntryModel convertToOtherTier = new ConvertToOtherTierEntry(this).generate('\u00e9');
        convertToOtherTier.withParent((BookEntryModel)transmutation.getFirst());
        convertToOtherTier.withCondition((BookConditionModel)this.condition().entryRead((BookEntryModel)transmutation.getSecond()));
        convertToOtherTier.hideWhileLocked(true);
        BookEntryModel digestionVat = new DigestionVatEntry(this).generate('\u00e8');
        digestionVat.withParent(convertToOtherTier);
        BookEntryModel requiredItems = new com.klikli_dev.theurgy.datagen.book.gettingstarted.exaltation.RequiredItemsEntry(this).generate('\u00ea');
        requiredItems.withParent(this.parent(digestionVat));
        BookEntryModel purifiedGold = new PurifiedGoldEntry(this).generate('\u011b');
        purifiedGold.withParent(requiredItems);
        BookEntryModel fermentation = new FermentationEntry(this).generate('\u00eb');
        fermentation.withParent(digestionVat);
        BookEntryModel digestion = new DigestionEntry(this).generate('\u0113');
        digestion.withParent(fermentation);
        digestion.withParent(purifiedGold);
        BookEntryModel niterToSulfurReformation = new com.klikli_dev.theurgy.datagen.book.gettingstarted.exaltation.NiterToSulfurReformationEntry(this).generate('\u0117');
        niterToSulfurReformation.withParent(digestion);
        BookEntryModel incubation = new com.klikli_dev.theurgy.datagen.book.gettingstarted.exaltation.IncubationEntry(this).generate('\u0119');
        incubation.withParent(niterToSulfurReformation);
        return Pair.of((Object)convertToOtherTier, (Object)incubation);
    }

    protected Pair<BookEntryModel, BookEntryModel> generateTransmutationEntries(Pair<BookEntryModel, BookEntryModel> reformation) {
        BookEntryModel convertToOtherType = new ConvertToOtherTypeEntry(this).generate('\u0165');
        convertToOtherType.withParent((BookEntryModel)reformation.getFirst());
        convertToOtherType.withCondition((BookConditionModel)this.condition().entryRead((BookEntryModel)reformation.getSecond()));
        convertToOtherType.hideWhileLocked(true);
        BookEntryModel fermentationVatEntry = new FermentationVatEntry(this).generate('\u0163');
        fermentationVatEntry.withParent(convertToOtherType);
        BookEntryModel requiredItemsTransmutation = new com.klikli_dev.theurgy.datagen.book.gettingstarted.transmutation.RequiredItemsEntry(this).generate('\u021b');
        requiredItemsTransmutation.withParent(this.parent(fermentationVatEntry).withDrawArrow(false));
        BookEntryModel fermentationTransmutation = new com.klikli_dev.theurgy.datagen.book.gettingstarted.transmutation.FermentationEntry(this).generate('\u01ad');
        fermentationTransmutation.withParent(fermentationVatEntry);
        BookEntryModel niterToNiterReformation = new NiterToNiterReformationEntry(this).generate('\u0288');
        niterToNiterReformation.withParent(fermentationTransmutation);
        BookEntryModel niterToSulfurReformation = new NiterToSulfurReformationEntry(this).generate('\u1e6b');
        niterToSulfurReformation.withParent(niterToNiterReformation);
        BookEntryModel incubation = new com.klikli_dev.theurgy.datagen.book.gettingstarted.transmutation.IncubationEntry(this).generate('\u1e6d');
        incubation.withParent(niterToSulfurReformation);
        return Pair.of((Object)convertToOtherType, (Object)incubation);
    }

    protected Pair<BookEntryModel, BookEntryModel> generateReformationEntries(BookEntryModel parent) {
        BookEntryModel convertWithinTypeAndTier = new ConvertWithinTypeAndTierEntry(this).generate('r');
        convertWithinTypeAndTier.withParent(parent);
        BookEntryModel reformationArray = new ReformationArrayEntry(this).generate('\u0213');
        reformationArray.withParent(convertWithinTypeAndTier);
        BookEntryModel requiredItems = new RequiredItemsEntry(this).generate('\u1e5b');
        requiredItems.withParent(this.parent(reformationArray).withDrawArrow(false));
        BookEntryModel source = new SourceEntry(this).generate('\u0155');
        source.withParent(this.parent(reformationArray));
        BookEntryModel target = new TargetEntry(this).generate('\u0159');
        target.withParent(reformationArray);
        BookEntryModel sulfuricFluxEmitter = new SulfuricFluxEmitterEntry(this).generate('\u0157');
        sulfuricFluxEmitter.withParent(source);
        sulfuricFluxEmitter.withParent(target);
        BookEntryModel result = new ResultEntry(this).generate('\u0280');
        result.withParent(sulfuricFluxEmitter);
        BookEntryModel reformationIncubation = new IncubationEntry(this).generate('\u0211');
        reformationIncubation.withParent(result);
        return Pair.of((Object)convertWithinTypeAndTier, (Object)reformationIncubation);
    }

    protected Pair<BookEntryModel, BookEntryModel> generateSpagyricsEntries(BookEntryModel parent) {
        BookEntryModel spagyrics = new SpagyricsEntry(this).generate('s');
        spagyrics.withParent(parent);
        BookEntryModel oreRefining = new OreRefiningEntry(this).generate('o');
        oreRefining.withParent(spagyrics);
        BookEntryModel neededApparatus = new NeededApparatusEntry(this).generate('\u00f3');
        neededApparatus.withParent(oreRefining);
        BookEntryModel createSolvent = new CreateSolventEntry(this).generate('\u0151');
        createSolvent.withParent(neededApparatus);
        BookEntryModel createSulfur = new CreateSulfurEntry(this).generate('\u00f6');
        createSulfur.withParent(createSolvent);
        BookEntryModel createSalt = new CreateSaltEntry(this).generate('\u00f4');
        createSalt.withParent(neededApparatus);
        BookEntryModel recycleStrata = new StrataRecyclingEntry(this).generate('\u01a1');
        recycleStrata.withParent(createSalt);
        BookEntryModel createMercury = new CreateMercuryEntry(this).generate('\u00f2');
        createMercury.withParent(neededApparatus);
        BookEntryModel incubation = new com.klikli_dev.theurgy.datagen.book.gettingstarted.spagyrics.IncubationEntry(this).generate('\u00f5');
        incubation.withParent(createMercury).withParent(createSalt).withParent(createSulfur);
        return Pair.of((Object)spagyrics, (Object)incubation);
    }

    protected void generateDivinationRodEntries(BookEntryModel parent) {
        DivinationRodEntryProvider rods = new DivinationRodEntryProvider(this.parent(), this.entryMap());
        BookEntryModel aboutDivinationRods = this.add(rods.aboutDivinationRods('d'));
        aboutDivinationRods.withParent(parent);
        BookEntryModel t1DivinationRod = this.add(rods.t1DivinationRodEntry('\u1e0d'));
        BookEntryModel abundantAndCommonSulfurAttunedDivinationRod = this.add(rods.abundantAndCommonSulfurAttunedDivinationRodEntry('\u0111'));
        BookEntryModel amethystDivinationRod = this.add(rods.amethystDivinationRodEntry('\u1e0b'));
        BookEntryModel t2DivinationRod = this.add(rods.t2DivinationRodEntry('\u010f'));
        BookEntryModel t3DivinationRod = this.add(rods.t3DivinationRodEntry('\u1e11'));
        BookEntryModel t4DivinationRod = this.add(rods.t4DivinationRodEntry('\u1e13'));
        BookEntryModel rareSulfurAttunedDivinationRod = this.add(rods.rareSulfurAttunedDivinationRodEntry('\u0256'));
        BookEntryModel preciousSulfurAttunedDivinationRod = this.add(rods.preciousSulfurAttunedDivinationRodEntry('\u1d91'));
        t1DivinationRod.withParent(aboutDivinationRods);
        abundantAndCommonSulfurAttunedDivinationRod.withParent(aboutDivinationRods);
        amethystDivinationRod.withParent(t1DivinationRod);
        amethystDivinationRod.withParent(abundantAndCommonSulfurAttunedDivinationRod);
        t2DivinationRod.withParent(amethystDivinationRod);
        t3DivinationRod.withParent(t2DivinationRod);
        t4DivinationRod.withParent(t3DivinationRod);
        rareSulfurAttunedDivinationRod.withParent(amethystDivinationRod);
        preciousSulfurAttunedDivinationRod.withParent(rareSulfurAttunedDivinationRod);
    }
}

