/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.render.cube;

import com.klikli_dev.theurgy.content.render.cube.CubeModel;
import com.klikli_dev.theurgy.util.EnumUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class CubeModelRenderer {
    private static final int[] combinedARGB = new int[EnumUtil.DIRECTIONS.length];
    private static final Vector3f NORMAL = new Vector3f(1.0f, 1.0f, 1.0f).normalize();
    private static final int X_AXIS_MASK = 1 << Direction.Axis.X.ordinal();
    private static final int Y_AXIS_MASK = 1 << Direction.Axis.Y.ordinal();
    private static final int Z_AXIS_MASK = 1 << Direction.Axis.Z.ordinal();

    private CubeModelRenderer() {
    }

    public static void renderCube(CubeModel object, PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay, FaceDisplay faceDisplay, Camera camera) {
        CubeModelRenderer.renderCube(object, matrix, buffer, argb, light, overlay, faceDisplay, camera, null);
    }

    public static void renderCube(CubeModel object, PoseStack matrix, VertexConsumer buffer, int[] colors, int light, int overlay, FaceDisplay faceDisplay, Camera camera) {
        CubeModelRenderer.renderCube(object, matrix, buffer, colors, light, overlay, faceDisplay, camera, null);
    }

    public static void renderCube(CubeModel cube, PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay, FaceDisplay faceDisplay, Camera camera, @Nullable Vec3 renderPos) {
        Arrays.fill(combinedARGB, argb);
        CubeModelRenderer.renderCube(cube, matrix, buffer, combinedARGB, light, overlay, faceDisplay, camera, renderPos);
    }

    public static void renderCube(CubeModel cube, PoseStack matrix, VertexConsumer buffer, int[] colors, int light, int overlay, FaceDisplay faceDisplay, Camera camera, @Nullable Vec3 renderPos) {
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[6];
        int axisToRender = 0;
        if (renderPos != null && faceDisplay != FaceDisplay.BOTH) {
            Vec3 camPos = camera.getPosition();
            Vec3 minPos = renderPos.add((double)cube.minX, (double)cube.minY, (double)cube.minZ);
            Vec3 maxPos = renderPos.add((double)cube.maxX, (double)cube.maxY, (double)cube.maxZ);
            for (Direction direction : EnumUtil.DIRECTIONS) {
                TextureAtlasSprite sprite = cube.getSpriteToRender(direction);
                if (sprite == null) continue;
                Direction.Axis axis = direction.getAxis();
                Direction.AxisDirection axisDirection = direction.getAxisDirection();
                double planeLocation = switch (axisDirection) {
                    default -> throw new MatchException(null, null);
                    case Direction.AxisDirection.POSITIVE -> axis.choose(maxPos.x, maxPos.y, maxPos.z);
                    case Direction.AxisDirection.NEGATIVE -> axis.choose(minPos.x, minPos.y, minPos.z);
                };
                double cameraPosition = axis.choose(camPos.x, camPos.y, camPos.z);
                if (faceDisplay.front == (axisDirection == Direction.AxisDirection.POSITIVE)) {
                    if (!(cameraPosition >= planeLocation)) continue;
                    sprites[direction.ordinal()] = sprite;
                    axisToRender |= 1 << axis.ordinal();
                    continue;
                }
                if (!(cameraPosition <= planeLocation)) continue;
                sprites[direction.ordinal()] = sprite;
                axisToRender |= 1 << axis.ordinal();
            }
        } else {
            for (Vec3 direction : EnumUtil.DIRECTIONS) {
                TextureAtlasSprite sprite = cube.getSpriteToRender((Direction)direction);
                if (sprite == null) continue;
                sprites[direction.ordinal()] = sprite;
                axisToRender |= 1 << direction.getAxis().ordinal();
            }
        }
        if (axisToRender == 0) {
            return;
        }
        int xShift = Mth.floor((float)cube.minX);
        int yShift = Mth.floor((float)cube.minY);
        int zShift = Mth.floor((float)cube.minZ);
        float minX = cube.minX - (float)xShift;
        float minY = cube.minY - (float)yShift;
        float minZ = cube.minZ - (float)zShift;
        float maxX = cube.maxX - (float)xShift;
        float maxY = cube.maxY - (float)yShift;
        float maxZ = cube.maxZ - (float)zShift;
        int xDelta = CubeModelRenderer.calculateDelta(minX, maxX);
        int yDelta = CubeModelRenderer.calculateDelta(minY, maxY);
        int zDelta = CubeModelRenderer.calculateDelta(minZ, maxZ);
        float[] xBounds = CubeModelRenderer.getBlockBounds(xDelta, minX, maxX);
        float[] yBounds = CubeModelRenderer.getBlockBounds(yDelta, minY, maxY);
        float[] zBounds = CubeModelRenderer.getBlockBounds(zDelta, minZ, maxZ);
        matrix.pushPose();
        matrix.translate((float)xShift, (float)yShift, (float)zShift);
        PoseStack.Pose lastMatrix = matrix.last();
        Matrix4f matrix4f = lastMatrix.pose();
        NormalData setNormal = new NormalData(lastMatrix.normal(), NORMAL, faceDisplay);
        Vector3f from = new Vector3f();
        Vector3f to = new Vector3f();
        int xIncrement = 1;
        int yIncrement = 1;
        int zIncrement = 1;
        if (axisToRender == X_AXIS_MASK) {
            xIncrement = Math.max(xDelta, 1);
        } else if (axisToRender == Y_AXIS_MASK) {
            yIncrement = Math.max(yDelta, 1);
        } else if (axisToRender == Z_AXIS_MASK) {
            zIncrement = Math.max(zDelta, 1);
        }
        for (int y = 0; y <= yDelta; y += yIncrement) {
            TextureAtlasSprite upSprite = y == yDelta ? sprites[Direction.UP.ordinal()] : null;
            TextureAtlasSprite downSprite = y == 0 ? sprites[Direction.DOWN.ordinal()] : null;
            from.y = yBounds[y];
            to.y = yBounds[y + 1];
            for (int z = 0; z <= zDelta; z += zIncrement) {
                TextureAtlasSprite northSprite = z == 0 ? sprites[Direction.NORTH.ordinal()] : null;
                TextureAtlasSprite southSprite = z == zDelta ? sprites[Direction.SOUTH.ordinal()] : null;
                from.z = zBounds[z];
                to.z = zBounds[z + 1];
                for (int x = 0; x <= xDelta; x += xIncrement) {
                    TextureAtlasSprite westSprite = x == 0 ? sprites[Direction.WEST.ordinal()] : null;
                    TextureAtlasSprite eastSprite = x == xDelta ? sprites[Direction.EAST.ordinal()] : null;
                    from.x = xBounds[x];
                    to.x = xBounds[x + 1];
                    CubeModelRenderer.putTexturedQuad(buffer, matrix4f, westSprite, from, to, Direction.WEST, colors, light, overlay, faceDisplay, setNormal);
                    CubeModelRenderer.putTexturedQuad(buffer, matrix4f, eastSprite, from, to, Direction.EAST, colors, light, overlay, faceDisplay, setNormal);
                    CubeModelRenderer.putTexturedQuad(buffer, matrix4f, northSprite, from, to, Direction.NORTH, colors, light, overlay, faceDisplay, setNormal);
                    CubeModelRenderer.putTexturedQuad(buffer, matrix4f, southSprite, from, to, Direction.SOUTH, colors, light, overlay, faceDisplay, setNormal);
                    CubeModelRenderer.putTexturedQuad(buffer, matrix4f, upSprite, from, to, Direction.UP, colors, light, overlay, faceDisplay, setNormal);
                    CubeModelRenderer.putTexturedQuad(buffer, matrix4f, downSprite, from, to, Direction.DOWN, colors, light, overlay, faceDisplay, setNormal);
                }
            }
        }
        matrix.popPose();
    }

    private static float[] getBlockBounds(int delta, float start, float end) {
        float[] bounds = new float[2 + delta];
        bounds[0] = start;
        int offset = (int)start;
        for (int i = 1; i <= delta; ++i) {
            bounds[i] = i + offset;
        }
        bounds[delta + 1] = end;
        return bounds;
    }

    private static int calculateDelta(float min, float max) {
        int delta = (int)(max - (float)((int)min));
        if ((double)max % 1.0 == 0.0) {
            --delta;
        }
        return delta;
    }

    private static void putTexturedQuad(VertexConsumer buffer, Matrix4f matrix, @Nullable TextureAtlasSprite spriteInfo, Vector3f from, Vector3f to, Direction face, int[] colors, int light, int overlay, FaceDisplay faceDisplay, NormalData setNormal) {
        Bounds uBounds;
        if (spriteInfo == null) {
            return;
        }
        float x1 = from.x();
        float y1 = from.y();
        float z1 = from.z();
        float x2 = to.x();
        float y2 = to.y();
        float z2 = to.z();
        Bounds vBounds = switch (face.getAxis()) {
            case Direction.Axis.Z -> {
                uBounds = Bounds.calculate(x2, x1);
                yield Bounds.calculate(y1, y2);
            }
            case Direction.Axis.X -> {
                uBounds = Bounds.calculate(z2, z1);
                yield Bounds.calculate(y1, y2);
            }
            default -> {
                uBounds = Bounds.calculate(x1, x2);
                yield Bounds.calculate(z2, z1);
            }
        };
        float minU = spriteInfo.getU(uBounds.min());
        float maxU = spriteInfo.getU(uBounds.max());
        float minV = spriteInfo.getV(1.0f - vBounds.max());
        float maxV = spriteInfo.getV(1.0f - vBounds.min());
        int argb = colors[face.ordinal()];
        switch (face) {
            case DOWN: {
                CubeModelRenderer.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, setNormal, x1, y1, z2, x1, y1, z1, x2, y1, z1, x2, y1, z2);
                break;
            }
            case UP: {
                CubeModelRenderer.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, setNormal, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1);
                break;
            }
            case NORTH: {
                CubeModelRenderer.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, setNormal, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1);
                break;
            }
            case SOUTH: {
                CubeModelRenderer.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, setNormal, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2);
                break;
            }
            case WEST: {
                CubeModelRenderer.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, setNormal, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1);
                break;
            }
            case EAST: {
                CubeModelRenderer.drawFace(buffer, matrix, argb, minU, maxU, minV, maxV, light, overlay, faceDisplay, setNormal, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2);
            }
        }
    }

    private static void drawFace(VertexConsumer buffer, Matrix4f matrix, int argb, float minU, float maxU, float minV, float maxV, int light, int overlay, FaceDisplay faceDisplay, NormalData setNormal, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        int red = FastColor.ARGB32.red((int)argb);
        int green = FastColor.ARGB32.green((int)argb);
        int blue = FastColor.ARGB32.blue((int)argb);
        int alpha = FastColor.ARGB32.alpha((int)argb);
        if (faceDisplay.front) {
            buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha).setUv(minU, maxV).setOverlay(overlay).setLight(light).setNormal(setNormal.front.x(), setNormal.front.y(), setNormal.front.z());
            buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha).setUv(minU, minV).setOverlay(overlay).setLight(light).setNormal(setNormal.front.x(), setNormal.front.y(), setNormal.front.z());
            buffer.addVertex(matrix, x3, y3, z3).setColor(red, green, blue, alpha).setUv(maxU, minV).setOverlay(overlay).setLight(light).setNormal(setNormal.front.x(), setNormal.front.y(), setNormal.front.z());
            buffer.addVertex(matrix, x4, y4, z4).setColor(red, green, blue, alpha).setUv(maxU, maxV).setOverlay(overlay).setLight(light).setNormal(setNormal.front.x(), setNormal.front.y(), setNormal.front.z());
        }
        if (faceDisplay.back) {
            buffer.addVertex(matrix, x4, y4, z4).setColor(red, green, blue, alpha).setUv(maxU, maxV).setOverlay(overlay).setLight(light).setNormal(setNormal.back.x(), setNormal.back.y(), setNormal.back.z());
            buffer.addVertex(matrix, x3, y3, z3).setColor(red, green, blue, alpha).setUv(maxU, minV).setOverlay(overlay).setLight(light).setNormal(setNormal.back.x(), setNormal.back.y(), setNormal.back.z());
            buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha).setUv(minU, minV).setOverlay(overlay).setLight(light).setNormal(setNormal.back.x(), setNormal.back.y(), setNormal.back.z());
            buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha).setUv(minU, maxV).setOverlay(overlay).setLight(light).setNormal(setNormal.back.x(), setNormal.back.y(), setNormal.back.z());
        }
    }

    public static enum FaceDisplay {
        FRONT(true, false),
        BACK(false, true),
        BOTH(true, true);

        private final boolean front;
        private final boolean back;

        private FaceDisplay(boolean front, boolean back) {
            this.front = front;
            this.back = back;
        }
    }

    private record NormalData(Vector3f front, Vector3f back) {
        private NormalData(Matrix3f normalMatrix, Vector3f setNormal, FaceDisplay faceDisplay) {
            this(faceDisplay.front ? NormalData.calculate(normalMatrix, setNormal.x(), setNormal.y(), setNormal.z()) : new Vector3f(), faceDisplay.back ? NormalData.calculate(normalMatrix, -setNormal.x(), -setNormal.y(), -setNormal.z()) : new Vector3f());
        }

        private static Vector3f calculate(Matrix3f normalMatrix, float x, float y, float z) {
            Vector3f matrixAdjustedNormal = new Vector3f(x, y, z);
            return matrixAdjustedNormal.mul((Matrix3fc)normalMatrix);
        }
    }

    private record Bounds(float min, float max) {
        public static Bounds calculate(float min, float max) {
            boolean bigger = min > max;
            min %= 1.0f;
            max %= 1.0f;
            if (bigger) {
                return new Bounds(min == 0.0f ? 1.0f : min, max);
            }
            return new Bounds(min, max == 0.0f ? 1.0f : max);
        }
    }
}

