/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.klikli_dev.theurgy.content.recipe.input.ReformationArrayRecipeInput;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ReformationRecipe
implements Recipe<ReformationArrayRecipeInput> {
    public static final int DEFAULT_TIME = 100;
    public static final MapCodec<ReformationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().fieldOf("sources").forGetter(r -> r.sources), (App)Ingredient.CODEC.fieldOf("target").forGetter(r -> r.target), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.fieldOf("mercuryFlux").forGetter(r -> r.mercuryFlux), (App)Codec.INT.optionalFieldOf("time", (Object)100).forGetter(r -> r.time)).apply((Applicative)instance, ReformationRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ReformationRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.sources, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.target, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, r -> r.result, (StreamCodec)ByteBufCodecs.INT, r -> r.mercuryFlux, (StreamCodec)ByteBufCodecs.INT, r -> r.time, ReformationRecipe::new);
    protected final List<Ingredient> sources;
    protected final Ingredient target;
    protected final ItemStack result;
    protected final int mercuryFlux;
    protected final int time;

    public ReformationRecipe(List<Ingredient> sources, Ingredient target, ItemStack result, int mercuryFlux, int time) {
        this.sources = sources;
        this.target = target;
        this.result = result;
        this.mercuryFlux = mercuryFlux;
        this.time = time;
    }

    public List<Ingredient> getSources() {
        return this.sources;
    }

    public Ingredient getTarget() {
        return this.target;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getMercuryFlux() {
        return this.mercuryFlux;
    }

    public int getTime() {
        return this.time;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(ReformationArrayRecipeInput pContainer, @NotNull Level pLevel) {
        if (pContainer.getMercuryFluxStorage().getEnergyStored() < this.mercuryFlux) {
            return false;
        }
        if (!this.target.test(pContainer.getTargetPedestalInv().getStackInSlot(0))) {
            return false;
        }
        ArrayList<Ingredient> remainingSources = new ArrayList<Ingredient>(this.sources);
        List<ItemStack> pedestalsToCheck = pContainer.getSourcePedestalInvs().stream().map(p -> p.getStackInSlot(0).copy()).toList();
        for (Ingredient source : remainingSources) {
            boolean found = false;
            for (ItemStack sourceInputStack : pedestalsToCheck) {
                if (!source.test(sourceInputStack)) continue;
                sourceInputStack.setCount(0);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull ReformationArrayRecipeInput pCraftingContainer, @NotNull HolderLookup.Provider pRegistries) {
        ItemStack result = this.result.copy();
        ItemStack targetItem = pCraftingContainer.getTargetPedestalInv().getStackInSlot(0);
        if (!targetItem.getComponents().isEmpty()) {
            result.applyComponents(targetItem.getComponents());
        }
        return result;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider pRegistries) {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.addAll(this.sources);
        return nonnulllist;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BlockRegistry.REFORMATION_RESULT_PEDESTAL.get());
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializerRegistry.REFORMATION.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypeRegistry.REFORMATION.get();
    }

    public static class Serializer
    implements RecipeSerializer<ReformationRecipe> {
        @NotNull
        public MapCodec<ReformationRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ReformationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

