/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.config.ServerConfig;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DivinationRodRecipe
extends ShapedRecipe {
    public DivinationRodRecipe(@NotNull String pGroup, @NotNull ShapedRecipePattern pPattern, @NotNull ItemStack pResult, boolean pShowNotification) {
        super(pGroup, CraftingBookCategory.MISC, pPattern, pResult, pShowNotification);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializerRegistry.DIVINATION_ROD.get();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput pInv, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        ItemStack result = this.getResultItem(pRegistries).copy();
        if (result.has(DataComponentRegistry.DIVINATION_LINKED_BLOCK) || result.has(DataComponentRegistry.DIVINATION_LINKED_TAG)) {
            return result;
        }
        for (int i = 0; i < pInv.size(); ++i) {
            ItemStack stack = pInv.getItem(i);
            if (stack.has(DataComponentRegistry.SULFUR_SOURCE_ITEM)) {
                Holder sourceItem = (Holder)stack.get(DataComponentRegistry.SULFUR_SOURCE_ITEM);
                Optional sourceItemKey = sourceItem.unwrapKey();
                if (sourceItemKey.isEmpty()) continue;
                String sourceBlock = this.translateToBlock(((ResourceKey)sourceItem.unwrapKey().get()).location().toString());
                if (sourceBlock == null) break;
                result.set(DataComponentRegistry.DIVINATION_LINKED_BLOCK, (Object)((Holder.Reference)BuiltInRegistries.BLOCK.getHolder(ResourceLocation.parse((String)sourceBlock)).get()));
                break;
            }
            if (!stack.has(DataComponentRegistry.SULFUR_SOURCE_TAG)) continue;
            TagKey sourceItemTag = (TagKey)stack.get(DataComponentRegistry.SULFUR_SOURCE_TAG);
            String sourceBlockTag = this.translateTagToBlock(sourceItemTag.location().toString());
            if (sourceBlockTag == null) break;
            result.set(DataComponentRegistry.DIVINATION_LINKED_TAG, (Object)BlockTags.create((ResourceLocation)ResourceLocation.parse((String)sourceBlockTag)));
            break;
        }
        return result;
    }

    @Nullable
    public String translateTagToBlock(@NotNull String sourceTag) {
        String path;
        String mapped = (String)((Map)ServerConfig.get().recipes.sulfurSourceToBlockMapping.get()).get(sourceTag);
        if (mapped != null) {
            return mapped;
        }
        if (sourceTag.equals("#minecraft:coals")) {
            return "#c:ores/coal";
        }
        String[] parts = sourceTag.split(":");
        String namespace = parts[0];
        String translatedPath = path = parts[1];
        if (path.contains("ingots/")) {
            translatedPath = path.replace("ingots/", "ores/");
        } else if (path.contains("nuggets/")) {
            translatedPath = path.replace("nuggets/", "ores/");
        } else if (path.contains("raw_materials/")) {
            translatedPath = path.replace("raw_materials/", "ores/");
        } else if (path.contains("dusts/")) {
            translatedPath = path.replace("dusts/", "ores/");
        } else if (path.contains("storage_blocks/")) {
            translatedPath = translatedPath.replace("storage_blocks/", "ores/");
        } else if (path.contains("gems/")) {
            translatedPath = translatedPath.replace("gems/", "ores/");
        }
        ResourceLocation translatedTag = ResourceLocation.parse((String)(namespace.substring(1) + ":" + translatedPath));
        if (BuiltInRegistries.BLOCK.getTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)translatedTag)).isPresent()) {
            return "#" + String.valueOf(translatedTag);
        }
        Theurgy.LOGGER.warn("Could not find an appropriate block tag for sulfur source ttag: " + sourceTag + ", tried tag: #" + String.valueOf(translatedTag));
        return null;
    }

    @Nullable
    public String translateToBlock(@NotNull String sourceId) {
        Optional<ResourceLocation> fallback;
        String mapped = (String)((Map)ServerConfig.get().recipes.sulfurSourceToBlockMapping.get()).get(sourceId);
        if (mapped != null) {
            return mapped;
        }
        String[] parts = sourceId.split(":");
        String namespace = parts[0];
        String path = parts[1];
        Object translatedPath = path;
        if (path.contains("raw_")) {
            translatedPath = path.replace("raw_", "");
        } else if (path.contains("_nugget")) {
            translatedPath = path.replace("_nugget", "");
        } else if (path.contains("_ingot")) {
            translatedPath = path.replace("_ingot", "");
        } else if (path.contains("_ore")) {
            translatedPath = path.replace("_ore", "");
            if (path.contains("deepslate_")) {
                translatedPath = ((String)translatedPath).replace("deepslate_", "");
            }
        } else if (path.contains("_dust")) {
            translatedPath = path.replace("_dust", "");
        } else if (path.contains("_block")) {
            translatedPath = path.replace("_block", "");
        }
        translatedPath = (String)translatedPath + "_ore";
        ResourceLocation translatedRL = ResourceLocation.parse((String)(namespace + ":" + (String)translatedPath));
        if (BuiltInRegistries.BLOCK.containsKey(translatedRL)) {
            return translatedRL.toString();
        }
        if (!BuiltInRegistries.BLOCK.containsKey(translatedRL) && (fallback = BuiltInRegistries.BLOCK.keySet().stream().filter(x -> x.getPath().equals(translatedRL.getPath())).findFirst()).isPresent()) {
            return fallback.get().toString();
        }
        Theurgy.LOGGER.warn("Could not find an appropriate block for sulfur source id: " + sourceId + ", tried path: " + (String)translatedPath);
        return null;
    }

    public static class Serializer
    implements RecipeSerializer<DivinationRodRecipe> {
        public static final MapCodec<DivinationRodRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340778_ -> p_340778_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)ShapedRecipePattern.MAP_CODEC.forGetter(p_311733_ -> p_311733_.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_311730_ -> p_311730_.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(ShapedRecipe::showNotification)).apply((Applicative)p_340778_, DivinationRodRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DivinationRodRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ShapedRecipe::getGroup, (StreamCodec)ShapedRecipePattern.STREAM_CODEC, r -> r.pattern, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, r -> r.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY), (StreamCodec)ByteBufCodecs.BOOL, ShapedRecipe::showNotification, DivinationRodRecipe::new);

        @NotNull
        public MapCodec<DivinationRodRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, DivinationRodRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

