/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.wire;

import com.klikli_dev.theurgy.content.behaviour.logistics.HasLeafNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.HasWireEndPoint;
import com.klikli_dev.theurgy.logistics.Logistics;
import com.klikli_dev.theurgy.logistics.Wire;
import com.klikli_dev.theurgy.logistics.WireEndPoint;
import com.klikli_dev.theurgy.logistics.Wires;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WireItem
extends Item {
    private final int maxRange;

    public WireItem(Item.Properties pProperties, int maxRange) {
        super(pProperties);
        this.maxRange = maxRange;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        if (!this.isWireEndPoint(pContext)) {
            return InteractionResult.FAIL;
        }
        WireEndPoint wirePoint = WireEndPoint.load(stack);
        if (wirePoint != null) {
            return this.connectWire(pContext, wirePoint);
        }
        return this.storeWireEndPoint(pContext);
    }

    protected boolean isWireEndPoint(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos pos = pContext.getClickedPos();
        return level.getBlockState(pos).getBlock() instanceof HasWireEndPoint;
    }

    protected InteractionResult connectWire(UseOnContext pContext, WireEndPoint wireEndPoint) {
        if (wireEndPoint.level() != pContext.getLevel().dimension()) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = pContext.getClickedPos();
        if (wireEndPoint.pos().equals((Object)pos)) {
            return InteractionResult.FAIL;
        }
        if (wireEndPoint.pos().distManhattan((Vec3i)pos) > this.maxRange) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = pContext.getItemInHand();
        WireEndPoint.removeFrom(stack);
        if (!pContext.getPlayer().getAbilities().instabuild) {
            stack.shrink(1);
        }
        Level level = pContext.getLevel();
        Wires.get(level).addWire(new Wire(wireEndPoint.pos(), pos));
        if (!level.isClientSide) {
            HasLeafNodeBehaviour blockEntity;
            GlobalPos posA = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos);
            GlobalPos posB = GlobalPos.of(wireEndPoint.level(), (BlockPos)wireEndPoint.pos());
            Logistics.get().add(posA, posB);
            BlockEntity blockEntity2 = level.getBlockEntity(posA.pos());
            if (blockEntity2 instanceof HasLeafNodeBehaviour) {
                blockEntity = (HasLeafNodeBehaviour)blockEntity2;
                Logistics.get().add(blockEntity.leafNode());
            }
            if ((blockEntity2 = level.getBlockEntity(posB.pos())) instanceof HasLeafNodeBehaviour) {
                blockEntity = (HasLeafNodeBehaviour)blockEntity2;
                Logistics.get().add(blockEntity.leafNode());
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult storeWireEndPoint(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        WireEndPoint wirePoint = new WireEndPoint(pContext.getClickedPos(), (ResourceKey<Level>)pContext.getLevel().dimension());
        wirePoint.save(stack);
        return InteractionResult.sidedSuccess((boolean)pContext.getLevel().isClientSide);
    }
}

