/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.sulfur;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurTier;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurType;
import com.klikli_dev.theurgy.content.item.sulfur.render.AlchemicalSulfurBEWLR;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.util.TagUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class AlchemicalSulfurItem
extends Item {
    private static final Map<Holder<Item>, ItemStack> sulfurSourceItemCache = new Object2ObjectOpenHashMap();
    private static final Map<TagKey<Item>, ItemStack> sulfurSourceTagCache = new Object2ObjectOpenHashMap();
    public boolean useAutomaticIconRendering = true;
    public boolean useAutomaticNameRendering = true;
    public boolean useAutomaticNameLangGeneration = true;
    public boolean provideAutomaticTooltipData = true;
    public boolean useAutomaticTooltipLangGeneration = true;
    public boolean overrideTagSourceName = false;
    public boolean overrideSourceName = false;
    public boolean autoGenerateSourceIdInRecipe = true;
    public Supplier<ItemStack> emptyJarStackSupplier = Suppliers.memoize(() -> new ItemStack((ItemLike)ItemRegistry.EMPTY_JAR_ICON.get()));
    public AlchemicalSulfurTier tier = AlchemicalSulfurTier.ABUNDANT;
    public AlchemicalSulfurType type = AlchemicalSulfurType.MISC;

    public AlchemicalSulfurItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ItemStack getEmptyJarStack(ItemStack sulfurStack) {
        Item item = sulfurStack.getItem();
        if (item instanceof AlchemicalSulfurItem) {
            AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
            return sulfur.emptyJarStackSupplier.get();
        }
        return ItemStack.EMPTY;
    }

    public static AlchemicalSulfurTier getTier(ItemStack sulfurStack) {
        Item item = sulfurStack.getItem();
        if (item instanceof AlchemicalSulfurItem) {
            AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
            return sulfur.tier;
        }
        return AlchemicalSulfurTier.ABUNDANT;
    }

    public static AlchemicalSulfurType getType(ItemStack sulfurStack) {
        Item item = sulfurStack.getItem();
        if (item instanceof AlchemicalSulfurItem) {
            AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
            return sulfur.type;
        }
        return AlchemicalSulfurType.MISC;
    }

    public static ItemStack getSourceStack(ItemStack sulfurStack) {
        if (sulfurStack.has(DataComponentRegistry.SULFUR_SOURCE_ITEM)) {
            return sulfurSourceItemCache.computeIfAbsent((Holder<Item>)((Holder)sulfurStack.get(DataComponentRegistry.SULFUR_SOURCE_ITEM)), ItemStack::new);
        }
        if (sulfurStack.has(DataComponentRegistry.SULFUR_SOURCE_TAG)) {
            return sulfurSourceTagCache.computeIfAbsent((TagKey<Item>)((TagKey)sulfurStack.get(DataComponentRegistry.SULFUR_SOURCE_TAG)), TagUtil::getItemStackForTag);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getSourceStack(Item sulfur) {
        if (sulfur.components().has((DataComponentType)DataComponentRegistry.SULFUR_SOURCE_ITEM.get())) {
            return sulfurSourceItemCache.computeIfAbsent((Holder<Item>)((Holder)sulfur.components().get((DataComponentType)DataComponentRegistry.SULFUR_SOURCE_ITEM.get())), ItemStack::new);
        }
        if (sulfur.components().has((DataComponentType)DataComponentRegistry.SULFUR_SOURCE_TAG.get())) {
            return sulfurSourceTagCache.computeIfAbsent((TagKey<Item>)((TagKey)sulfur.components().get((DataComponentType)DataComponentRegistry.SULFUR_SOURCE_TAG.get())), TagUtil::getItemStackForTag);
        }
        return ItemStack.EMPTY;
    }

    public static List<MutableComponent> getTooltipData(ItemStack sulfurStack) {
        Item item = sulfurStack.getItem();
        if (item instanceof AlchemicalSulfurItem) {
            AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
            if (sulfur.provideAutomaticTooltipData) {
                AlchemicalSulfurTier tier = AlchemicalSulfurItem.getTier(sulfurStack);
                AlchemicalSulfurType type = AlchemicalSulfurItem.getType(sulfurStack);
                return ImmutableList.of((Object)sulfur.getSourceName(sulfurStack), (Object)ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)tier.descriptionId()).withStyle(Style.EMPTY.withColor(tier.color).withItalic(Boolean.valueOf(true)))), (Object)ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)type.descriptionId()).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withItalic(Boolean.valueOf(true)))));
            }
        }
        return ImmutableList.of();
    }

    public static MutableComponent formatSourceName(MutableComponent sourceName, AlchemicalSulfurTier tier) {
        return sourceName.withStyle(Style.EMPTY.withColor(tier.color()).withItalic(Boolean.valueOf(true)));
    }

    public AlchemicalSulfurItem tier(AlchemicalSulfurTier tier) {
        this.tier = tier;
        return this;
    }

    public AlchemicalSulfurTier tier() {
        return this.tier;
    }

    public AlchemicalSulfurItem type(AlchemicalSulfurType type) {
        this.type = type;
        return this;
    }

    public AlchemicalSulfurType type() {
        return this.type;
    }

    public AlchemicalSulfurItem noAuto() {
        this.useAutomaticIconRendering = false;
        this.useAutomaticNameRendering = false;
        this.useAutomaticNameLangGeneration = false;
        this.provideAutomaticTooltipData = false;
        this.useAutomaticTooltipLangGeneration = false;
        this.overrideTagSourceName = false;
        return this;
    }

    public AlchemicalSulfurItem autoIcon(boolean value) {
        this.useAutomaticIconRendering = value;
        return this;
    }

    public AlchemicalSulfurItem withJarIcon(Supplier<ItemStack> emptyJarStackSupplier) {
        this.emptyJarStackSupplier = emptyJarStackSupplier;
        return this;
    }

    public AlchemicalSulfurItem autoName(boolean value) {
        return this.autoName(value, value);
    }

    public AlchemicalSulfurItem autoName(boolean rendering, boolean langGeneration) {
        this.useAutomaticNameRendering = rendering;
        this.useAutomaticNameLangGeneration = langGeneration;
        return this;
    }

    public AlchemicalSulfurItem autoTooltip(boolean value) {
        return this.autoTooltip(value, value);
    }

    public AlchemicalSulfurItem autoTooltip(boolean rendering, boolean langGeneration) {
        this.provideAutomaticTooltipData = rendering;
        this.useAutomaticTooltipLangGeneration = langGeneration;
        return this;
    }

    public AlchemicalSulfurItem overrideTagSourceName(boolean value) {
        this.overrideTagSourceName = value;
        return this;
    }

    public AlchemicalSulfurItem overrideSourceName(boolean value) {
        this.overrideSourceName = value;
        this.autoGenerateSourceIdInRecipe = !value;
        return this;
    }

    public AlchemicalSulfurItem autoGenerateSourceIdInRecipe(boolean value) {
        this.autoGenerateSourceIdInRecipe = value;
        return this;
    }

    public MutableComponent getSourceName(ItemStack pStack) {
        if (this.overrideSourceName) {
            return AlchemicalSulfurItem.formatSourceName(Component.translatable((String)(pStack.getDescriptionId() + ".source")), this.tier);
        }
        ItemStack source = AlchemicalSulfurItem.getSourceStack(pStack);
        if (!source.isEmpty()) {
            if (pStack.has(DataComponentRegistry.SULFUR_SOURCE_TAG) && this.overrideTagSourceName) {
                return AlchemicalSulfurItem.formatSourceName(Component.translatable((String)Util.makeDescriptionId((String)"tag", (ResourceLocation)((TagKey)pStack.get(DataComponentRegistry.SULFUR_SOURCE_TAG)).location())), this.tier);
            }
            Component component = source.getHoverName();
            if (component instanceof MutableComponent) {
                MutableComponent hoverName = (MutableComponent)component;
                return AlchemicalSulfurItem.formatSourceName(hoverName, this.tier);
            }
        }
        return Component.translatable((String)"item.theurgy.alchemical_sulfur.unknown_source");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return AlchemicalSulfurBEWLR.get();
            }
        });
    }

    public Component getName(ItemStack pStack) {
        if (this.useAutomaticNameRendering) {
            AlchemicalSulfurTier tier = AlchemicalSulfurItem.getTier(pStack);
            AlchemicalSulfurType type = AlchemicalSulfurItem.getType(pStack);
            return Component.translatable((String)this.getDescriptionId(pStack), (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)this.getSourceName(pStack)), ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)tier.descriptionId()).withStyle(Style.EMPTY.withColor(tier.color).withItalic(Boolean.valueOf(true)))), ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)type.descriptionId()).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withItalic(Boolean.valueOf(true))))});
        }
        return super.getName(pStack);
    }
}

