/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.filter;

import com.klikli_dev.theurgy.content.item.filter.Filter;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;

public class ListFilter
extends Filter {
    public List<ItemStack> filterItems;
    public boolean shouldRespectDataComponents;
    public boolean isDenyList;

    protected ListFilter(ItemStack filter) {
        super(filter);
    }

    @Override
    protected void initFromFilterItemStack(ItemStack filterItemStack) {
        this.filterItems = this.getFilterItems(filterItemStack);
        this.shouldRespectDataComponents = (Boolean)filterItemStack.getOrDefault(DataComponentRegistry.FILTER_RESPECTS_DATA_COMPONENTS, (Object)false);
        this.isDenyList = (Boolean)filterItemStack.getOrDefault(DataComponentRegistry.FILTER_IS_DENY_LIST, (Object)false);
    }

    @Override
    public boolean test(Level world, ItemStack stack, boolean matchDataComponents) {
        for (ItemStack filterItemStack : this.filterItems) {
            if (!this.testFilterItemStack(filterItemStack, stack, this.shouldRespectDataComponents)) continue;
            return !this.isDenyList;
        }
        return this.isDenyList;
    }

    @Override
    public boolean isEmpty() {
        return this.filterItems.isEmpty();
    }

    private boolean testFilterItemStack(ItemStack filterItemStack, ItemStack stackToTest, boolean matchDataComponents) {
        if (matchDataComponents) {
            return ItemStack.isSameItemSameComponents((ItemStack)filterItemStack, (ItemStack)stackToTest);
        }
        return ItemStack.isSameItem((ItemStack)filterItemStack, (ItemStack)stackToTest);
    }

    private List<ItemStack> getFilterItems(ItemStack filter) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (!filter.has(DataComponentRegistry.FILTER_ITEMS)) {
            return result;
        }
        ItemContainerContents items = (ItemContainerContents)filter.get(DataComponentRegistry.FILTER_ITEMS);
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            result.add(stackInSlot);
        }
        return result;
    }
}

