/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.filter;

import com.klikli_dev.theurgy.content.item.filter.EmptyFilter;
import com.klikli_dev.theurgy.content.item.filter.ListFilter;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public abstract class Filter
implements INBTSerializable<CompoundTag> {
    private ItemStack filterItemStack;

    protected Filter(ItemStack filter) {
        this.filterItemStack = filter;
        this.initFromFilterItemStack(filter);
    }

    public static Filter of(ItemStack filter) {
        if (ItemRegistry.LIST_FILTER.get() == filter.getItem()) {
            return new ListFilter(filter);
        }
        return Filter.empty();
    }

    public static Filter of(HolderLookup.Provider provider, CompoundTag nbt) {
        return Filter.of((ItemStack)((Pair)ItemStack.OPTIONAL_CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).getOrThrow()).getFirst());
    }

    public static Filter empty() {
        return new EmptyFilter();
    }

    public ItemStack item() {
        return this.filterItemStack;
    }

    protected abstract void initFromFilterItemStack(ItemStack var1);

    public boolean test(Level level, ItemStack stack) {
        return this.test(level, stack, false);
    }

    public abstract boolean test(Level var1, ItemStack var2, boolean var3);

    public abstract boolean isEmpty();

    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return (CompoundTag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.filterItemStack).getOrThrow();
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        ItemStack item;
        this.filterItemStack = item = (ItemStack)((Pair)ItemStack.OPTIONAL_CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).getOrThrow()).getFirst();
        this.initFromFilterItemStack(item);
    }
}

