/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.logistics;

import com.klikli_dev.theurgy.content.behaviour.logistics.ExtractorNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.InserterNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeMode;
import com.klikli_dev.theurgy.content.item.filter.Filter;
import com.klikli_dev.theurgy.logistics.Logistics;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.util.Lazy;

public abstract class LeafNodeBehaviour<T, C> {
    protected BlockEntity blockEntity;
    protected Lazy<GlobalPos> globalPos;
    protected BlockCapability<T, C> capabilityType;
    protected Filter filter;
    protected List<BlockPos> targets;
    protected int frequency;

    public LeafNodeBehaviour(BlockEntity blockEntity, BlockCapability<T, C> capabilityType) {
        this.blockEntity = blockEntity;
        this.globalPos = Lazy.of(() -> GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)this.blockEntity.getBlockPos()));
        this.capabilityType = capabilityType;
        this.targets = new ArrayList<BlockPos>();
        this.frequency = 0;
        this.filter = Filter.empty();
    }

    public Level level() {
        return this.blockEntity.getLevel();
    }

    public GlobalPos globalPos() {
        return (GlobalPos)this.globalPos.get();
    }

    public Filter filter() {
        return this.filter;
    }

    public void filter(Filter filter) {
        this.filter = filter;
    }

    public BlockCapability<T, C> capabilityType() {
        return this.capabilityType;
    }

    public List<BlockPos> targets() {
        return this.targets;
    }

    public int frequency() {
        return this.frequency;
    }

    public ExtractorNodeBehaviour<T, C> asExtractor() {
        return (ExtractorNodeBehaviour)this;
    }

    public InserterNodeBehaviour<T, C> asInserter() {
        return (InserterNodeBehaviour)this;
    }

    public void onLoad() {
        Logistics.get().add(this);
    }

    public void onChunkUnload() {
        Logistics.get().remove(this, false);
    }

    public void onDestroyed() {
        Logistics.get().remove(this, true);
    }

    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.writeNetwork(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.readNetwork(pTag, pRegistries);
    }

    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putInt("frequency", this.frequency);
        ListTag list = new ListTag();
        for (BlockPos target : this.targets) {
            list.add((Object)LongTag.valueOf((long)target.asLong()));
        }
        pTag.put("targets", (Tag)list);
    }

    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.frequency = pTag.getInt("frequency");
        this.targets = new ArrayList<BlockPos>();
        ListTag list = pTag.getList("targets", 4);
        for (int i = 0; i < list.size(); ++i) {
            this.targets.add(BlockPos.of((long)((LongTag)list.get(i)).getAsLong()));
        }
    }

    public abstract LeafNodeMode mode();

    public abstract C getTargetContext(BlockPos var1);
}

