/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.filter;

import com.klikli_dev.theurgy.content.item.filter.Filter;
import com.klikli_dev.theurgy.content.item.filter.FilterItem;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class FilterBehaviour {
    protected BlockEntity blockEntity;
    protected Consumer<Filter> callback;
    protected Filter filter;

    public FilterBehaviour(BlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.callback = stack -> {};
        this.filter = Filter.empty();
    }

    public Filter filter() {
        return this.filter;
    }

    public void filter(Filter filter) {
        this.filter = filter;
        this.callback.accept(filter);
    }

    public FilterBehaviour withCallback(Consumer<Filter> callback) {
        this.callback = callback;
        return this;
    }

    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.writeNetwork(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.readNetwork(pTag, pRegistries);
    }

    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("filter", (Tag)this.filter.serializeNBT(pRegistries));
    }

    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.filter(Filter.of(pRegistries, pTag.getCompound("filter")));
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack pStack, @NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHitResult) {
        if (this.filter().isEmpty()) {
            if (pStack.isEmpty() || !(pStack.getItem() instanceof FilterItem)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            Filter filter = Filter.of(pStack.copyWithCount(1));
            if (!filter.isEmpty()) {
                this.filter(filter);
                pStack.consume(1, (LivingEntity)pPlayer);
            }
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        if (pStack.isEmpty()) {
            ItemStack stack = this.filter().item().copy();
            this.filter(Filter.empty());
            ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)stack);
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

