/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator;

import com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator.SalAmmoniacAccumulatorCraftingBehaviour;
import com.klikli_dev.theurgy.content.particle.ParticleColor;
import com.klikli_dev.theurgy.content.particle.coloredbubble.ColoredBubbleParticleProvider;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SalAmmoniacAccumulatorBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public ItemStackHandler inventory = new Inventory();
    public FluidTank waterTank;
    protected SalAmmoniacAccumulatorCraftingBehaviour craftingBehaviour = new SalAmmoniacAccumulatorCraftingBehaviour((BlockEntity)this, () -> this.inventory, () -> this.inventory, () -> this.waterTank, this::getOutputTank);
    private boolean checkOutputTankOnNextQuery = true;
    private boolean hasOutputTank;

    public SalAmmoniacAccumulatorBlockEntity(BlockPos pPos, BlockState pState) {
        super(BlockEntityRegistry.SAL_AMMONIAC_ACCUMULATOR.get(), pPos, pState);
        this.waterTank = new WaterTank(10000, this.craftingBehaviour::canProcess);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag, pRegistries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.readNetwork(tag, pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider pRegistries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.readNetwork(tag, pRegistries);
        }
    }

    public void readNetwork(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (tag.contains("waterTank")) {
            this.waterTank.readFromNBT(pRegistries, tag.getCompound("waterTank"));
        }
        if (tag.contains("inventory")) {
            this.inventory.deserializeNBT(pRegistries, tag.getCompound("inventory"));
        }
        this.craftingBehaviour.readNetwork(tag, pRegistries);
    }

    public void writeNetwork(CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("waterTank", (Tag)this.waterTank.writeToNBT(pRegistries, new CompoundTag()));
        tag.put("inventory", (Tag)this.inventory.serializeNBT(pRegistries));
        this.craftingBehaviour.writeNetwork(tag, pRegistries);
    }

    public void sendBlockUpdated() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public void tickServer() {
        if (!this.hasOutputTank()) {
            return;
        }
        boolean hasInput = !this.waterTank.isEmpty();
        this.craftingBehaviour.tickServer(true, hasInput);
    }

    public void tickClient() {
        boolean isProcessing = this.craftingBehaviour.isProcessing();
        if (isProcessing && this.getLevel().getGameTime() % 2L == 0L) {
            FluidStack fluidStack = this.waterTank.getFluid();
            IClientFluidTypeExtensions fluidClientExtension = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            int waterColor = fluidClientExtension.getTintColor(fluidStack);
            ParticleColor particleColor = this.inventory.getStackInSlot(0).is(ItemTagRegistry.GEMS_SAL_AMMONIAC) ? new ParticleColor(255, 192, 128) : ParticleColor.fromInt(waterColor);
            float fluidHeight = (float)fluidStack.getAmount() / (float)this.waterTank.getCapacity();
            fluidHeight += 0.3f;
            this.getLevel().addParticle(ColoredBubbleParticleProvider.createOptions(particleColor), (double)this.getBlockPos().getX() + 0.33 + 0.33 * (double)this.getLevel().getRandom().nextFloat(), (double)((float)this.getBlockPos().getY() + (fluidHeight *= 0.6f)), (double)this.getBlockPos().getZ() + 0.33 + 0.33 * (double)this.getLevel().getRandom().nextFloat(), 0.0, 0.015, 0.0);
        }
    }

    public IFluidHandler getOutputTank() {
        BlockPos below = this.getBlockPos().below();
        return (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, below, null);
    }

    public void validateOutputTank() {
        BlockPos below = this.getBlockPos().below();
        this.hasOutputTank = this.level.getCapability(Capabilities.FluidHandler.BLOCK, below, null) != null;
    }

    public boolean hasOutputTank() {
        if (this.checkOutputTankOnNextQuery) {
            this.checkOutputTankOnNextQuery = false;
            this.validateOutputTank();
        }
        return this.hasOutputTank;
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("inventory", (Tag)this.inventory.serializeNBT(pRegistries));
        pTag.put("waterTank", (Tag)this.waterTank.writeToNBT(pRegistries, new CompoundTag()));
        this.craftingBehaviour.saveAdditional(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("inventory")) {
            this.inventory.deserializeNBT(pRegistries, pTag.getCompound("inventory"));
        }
        if (pTag.contains("waterTank")) {
            this.waterTank.readFromNBT(pRegistries, pTag.getCompound("waterTank"));
        }
        this.craftingBehaviour.loadAdditional(pTag, pRegistries);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public class Inventory
    extends MonitoredItemStackHandler {
        public Inventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            SalAmmoniacAccumulatorBlockEntity.this.craftingBehaviour.onInputItemChanged(oldStack, newStack);
            SalAmmoniacAccumulatorBlockEntity.this.sendBlockUpdated();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return SalAmmoniacAccumulatorBlockEntity.this.craftingBehaviour.canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            SalAmmoniacAccumulatorBlockEntity.this.setChanged();
        }
    }

    public class WaterTank
    extends FluidTank {
        public WaterTank(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        protected void onContentsChanged() {
            SalAmmoniacAccumulatorBlockEntity.this.setChanged();
            SalAmmoniacAccumulatorBlockEntity.this.sendBlockUpdated();
        }
    }
}

