/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationArrayCraftingBehaviour;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationResultPedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationSourcePedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationTargetPedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.content.behaviour.crafting.CraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.selection.SelectionBehaviour;
import com.klikli_dev.theurgy.content.capability.DefaultMercuryFluxStorage;
import com.klikli_dev.theurgy.content.entity.FollowProjectile;
import com.klikli_dev.theurgy.content.recipe.input.ReformationArrayRecipeInput;
import com.klikli_dev.theurgy.content.render.Color;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.util.EntityUtil;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class SulfuricFluxEmitterBlockEntity
extends BlockEntity {
    public static final int CAPACITY = 1000;
    public MercuryFluxStorage mercuryFluxStorage = new MercuryFluxStorage(1000);
    public boolean isValidMultiblock;
    protected List<SulfuricFluxEmitterSelectedPoint> sourcePedestals = new ArrayList<SulfuricFluxEmitterSelectedPoint>();
    protected List<SulfuricFluxEmitterSelectedPoint> sourcePedestalsWithContents = new ArrayList<SulfuricFluxEmitterSelectedPoint>();
    protected SulfuricFluxEmitterSelectedPoint targetPedestal;
    protected SulfuricFluxEmitterSelectedPoint resultPedestal;
    protected CraftingBehaviour<?, ?, ?> craftingBehaviour = new ReformationArrayCraftingBehaviour((BlockEntity)this, () -> this.ItemHandlerRecipeInput, () -> null, this::getOutputInventory, () -> this.mercuryFluxStorage);
    protected boolean checkValidMultiblockOnNextQuery = true;
    protected boolean hasSourceItems;
    protected boolean hasTargetItem;
    private ReformationArrayRecipeInput ItemHandlerRecipeInput;

    public SulfuricFluxEmitterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.SULFURIC_FLUX_EMITTER.get(), pPos, pBlockState);
    }

    public void removeResultPedestal(ReformationResultPedestalBlockEntity pedestal) {
        this.isValidMultiblock = false;
        this.onDisassembleMultiblock();
    }

    public void removeTargetPedestal(ReformationTargetPedestalBlockEntity pedestal) {
        this.isValidMultiblock = false;
        this.hasTargetItem = false;
        this.onDisassembleMultiblock();
    }

    public void removeSourcePedestal(ReformationSourcePedestalBlockEntity pedestal) {
        boolean hasRemainingPedestals = this.sourcePedestals.stream().filter(p -> !p.getBlockPos().equals((Object)pedestal.getBlockPos())).map(p -> this.level.getBlockEntity(p.getBlockPos())).anyMatch(e -> e instanceof ReformationSourcePedestalBlockEntity);
        if (!hasRemainingPedestals) {
            this.isValidMultiblock = false;
            this.hasSourceItems = false;
            this.onDisassembleMultiblock();
        } else {
            this.onSourcePedestalContentChange(null);
        }
    }

    public boolean isValidMultiblock() {
        if (this.checkValidMultiblockOnNextQuery) {
            this.checkValidMultiblockOnNextQuery = false;
            this.validateMultiblock();
        }
        return this.isValidMultiblock;
    }

    public void validateMultiblock() {
        boolean wasValidMultiblock = this.isValidMultiblock;
        this.isValidMultiblock = true;
        if (this.targetPedestal != null) {
            BlockEntity targetPedestalBlockEntity = this.level.getBlockEntity(this.targetPedestal.getBlockPos());
            if (!(targetPedestalBlockEntity instanceof ReformationTargetPedestalBlockEntity)) {
                this.isValidMultiblock = false;
            }
        } else {
            this.isValidMultiblock = false;
        }
        if (this.resultPedestal != null) {
            BlockEntity resultPedestalBlockEntity = this.level.getBlockEntity(this.resultPedestal.getBlockPos());
            if (!(resultPedestalBlockEntity instanceof ReformationResultPedestalBlockEntity)) {
                this.isValidMultiblock = false;
            }
        } else {
            this.isValidMultiblock = false;
        }
        boolean hasSourcePedestals = false;
        for (SulfuricFluxEmitterSelectedPoint sourcePedestal : this.sourcePedestals) {
            BlockEntity sourcePedestalBlockEntity = this.level.getBlockEntity(sourcePedestal.getBlockPos());
            if (!(sourcePedestalBlockEntity instanceof ReformationSourcePedestalBlockEntity)) continue;
            hasSourcePedestals = true;
        }
        this.sourcePedestalsWithContents.clear();
        if (!hasSourcePedestals) {
            this.isValidMultiblock = false;
        } else {
            this.onSourcePedestalContentChange(null);
        }
        if (wasValidMultiblock != this.isValidMultiblock) {
            if (this.isValidMultiblock) {
                this.onAssembleMultiblock();
            } else {
                this.onDisassembleMultiblock();
            }
        }
    }

    public void onAssembleMultiblock() {
        ReformationTargetPedestalBlockEntity targetPedestalBlockEntity = (ReformationTargetPedestalBlockEntity)this.level.getBlockEntity(this.targetPedestal.getBlockPos());
        targetPedestalBlockEntity.setSulfuricFluxEmitter(this);
        this.onTargetPedestalContentChange(targetPedestalBlockEntity);
        ReformationResultPedestalBlockEntity resultPedestalBlockEntity = (ReformationResultPedestalBlockEntity)this.level.getBlockEntity(this.resultPedestal.getBlockPos());
        resultPedestalBlockEntity.setSulfuricFluxEmitter(this);
        List<IItemHandlerModifiable> sourceInventories = this.sourcePedestals.stream().map(p -> this.level.getBlockEntity(p.getBlockPos())).filter(e -> e instanceof ReformationSourcePedestalBlockEntity).map(e -> (ReformationSourcePedestalBlockEntity)((Object)e)).peek(e -> e.setSulfuricFluxEmitter(this)).map(e -> e.inputInventory).map(e -> e).toList();
        this.onSourcePedestalContentChange(null);
        this.ItemHandlerRecipeInput = new ReformationArrayRecipeInput(sourceInventories, (IItemHandlerModifiable)targetPedestalBlockEntity.inputInventory, this.mercuryFluxStorage);
    }

    public void onDisassembleMultiblock() {
        this.ItemHandlerRecipeInput = null;
    }

    public IItemHandlerModifiable getOutputInventory() {
        BlockPos pos = this.resultPedestal.getBlockPos();
        BlockEntity blockEntity = this.level.getBlockEntity(pos);
        if (blockEntity instanceof ReformationResultPedestalBlockEntity) {
            ReformationResultPedestalBlockEntity pedestal = (ReformationResultPedestalBlockEntity)blockEntity;
            return pedestal.outputInventory;
        }
        return null;
    }

    public void tickServer() {
        boolean hasInput = this.isValidMultiblock() && this.hasSourceItems && this.hasTargetItem;
        this.craftingBehaviour.tickServer(true, hasInput);
    }

    public void tickClient() {
        if (this.craftingBehaviour.isProcessing() && this.level.getGameTime() % 40L == 0L) {
            DistHelper.sendTargetProjectile(this);
        }
    }

    public void onLoad() {
        if (this.targetPedestal != null) {
            this.targetPedestal.setLevel(this.level);
        }
        if (this.resultPedestal != null) {
            this.resultPedestal.setLevel(this.level);
        }
        this.sourcePedestals.forEach(point -> point.setLevel(this.getLevel()));
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("mercuryFluxStorage", this.mercuryFluxStorage.serializeNBT(pRegistries));
        pTag.put("sourcePedestals", (Tag)SulfuricFluxEmitterSelectedPoint.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.sourcePedestals).getOrThrow(e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.sourcePedestals))));
        if (this.targetPedestal != null) {
            pTag.put("targetPedestal", (Tag)SulfuricFluxEmitterSelectedPoint.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.targetPedestal).getOrThrow(e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.targetPedestal))));
        }
        if (this.resultPedestal != null) {
            pTag.put("resultPedestal", (Tag)SulfuricFluxEmitterSelectedPoint.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.resultPedestal).getOrThrow(e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.resultPedestal))));
        }
        this.craftingBehaviour.saveAdditional(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("mercuryFluxStorage")) {
            this.mercuryFluxStorage.deserializeNBT(pRegistries, pTag.get("mercuryFluxStorage"));
        }
        if (pTag.contains("sourcePedestals")) {
            this.sourcePedestals.clear();
            this.sourcePedestals.addAll((Collection)SulfuricFluxEmitterSelectedPoint.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.get("sourcePedestals")).getOrThrow(e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.get("sourcePedestals")))));
        }
        if (pTag.contains("targetPedestal")) {
            this.targetPedestal = (SulfuricFluxEmitterSelectedPoint)SulfuricFluxEmitterSelectedPoint.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.get("targetPedestal")).getOrThrow(e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.get("targetPedestal"))));
        }
        if (pTag.contains("resultPedestal")) {
            this.resultPedestal = (SulfuricFluxEmitterSelectedPoint)SulfuricFluxEmitterSelectedPoint.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.get("resultPedestal")).getOrThrow(e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.get("resultPedestal"))));
        }
        this.craftingBehaviour.loadAdditional(pTag, pRegistries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag, pRegistries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.readNetwork(tag, pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider pRegistries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.readNetwork(tag, pRegistries);
        }
    }

    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (pTag.contains("sourcePedestalsWithContents")) {
            this.sourcePedestalsWithContents.clear();
            this.sourcePedestalsWithContents.addAll((Collection)SulfuricFluxEmitterSelectedPoint.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.get("sourcePedestalsWithContents")).getOrThrow(e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.get("sourcePedestalsWithContents")))));
        }
        if (pTag.contains("targetPedestal")) {
            this.targetPedestal = (SulfuricFluxEmitterSelectedPoint)SulfuricFluxEmitterSelectedPoint.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.get("targetPedestal")).getOrThrow(e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.get("targetPedestal"))));
        }
        if (pTag.contains("resultPedestal")) {
            this.resultPedestal = (SulfuricFluxEmitterSelectedPoint)SulfuricFluxEmitterSelectedPoint.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.get("resultPedestal")).getOrThrow(e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.get("resultPedestal"))));
        }
        this.craftingBehaviour.readNetwork(pTag, pRegistries);
    }

    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("sourcePedestalsWithContents", (Tag)SulfuricFluxEmitterSelectedPoint.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.sourcePedestalsWithContents).getOrThrow(e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.sourcePedestalsWithContents))));
        if (this.targetPedestal != null) {
            pTag.put("targetPedestal", (Tag)SulfuricFluxEmitterSelectedPoint.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.targetPedestal).getOrThrow(e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.targetPedestal))));
        }
        if (this.resultPedestal != null) {
            pTag.put("resultPedestal", (Tag)SulfuricFluxEmitterSelectedPoint.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.resultPedestal).getOrThrow(e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.resultPedestal))));
        }
        this.craftingBehaviour.writeNetwork(pTag, pRegistries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        if (pComponentInput.get(DataComponentRegistry.MERCURY_FLUX_STORAGE) != null) {
            this.mercuryFluxStorage.setEnergyStored((Integer)pComponentInput.get(DataComponentRegistry.MERCURY_FLUX_STORAGE));
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentRegistry.MERCURY_FLUX_STORAGE, (Object)this.mercuryFluxStorage.getEnergyStored());
    }

    public SelectionBehaviour<SulfuricFluxEmitterSelectedPoint> getSelectionBehaviour() {
        return ((SulfuricFluxEmitterBlock)((Object)BlockRegistry.SULFURIC_FLUX_EMITTER.get())).selectionBehaviour();
    }

    public void setSelectedPoints(List<SulfuricFluxEmitterSelectedPoint> sourcePedestals, SulfuricFluxEmitterSelectedPoint targetPedestal, SulfuricFluxEmitterSelectedPoint resultPedestal) {
        int range = this.getSelectionBehaviour().getBlockRange();
        this.sourcePedestals.clear();
        this.sourcePedestals.addAll(sourcePedestals);
        this.sourcePedestals.removeIf(p -> !p.getBlockPos().closerThan((Vec3i)this.getBlockPos(), (double)range));
        SulfuricFluxEmitterSelectedPoint sulfuricFluxEmitterSelectedPoint = targetPedestal == null ? null : (this.targetPedestal = targetPedestal.getBlockPos().closerThan((Vec3i)this.getBlockPos(), (double)range) ? targetPedestal : null);
        this.resultPedestal = resultPedestal == null ? null : (resultPedestal.getBlockPos().closerThan((Vec3i)this.getBlockPos(), (double)range) ? resultPedestal : null);
        this.checkValidMultiblockOnNextQuery = true;
        this.setChanged();
    }

    public void setSelectedPointsClient(List<SulfuricFluxEmitterSelectedPoint> sourcePedestals, SulfuricFluxEmitterSelectedPoint targetPedestal, SulfuricFluxEmitterSelectedPoint resultPedestal) {
        this.sourcePedestals.clear();
        this.sourcePedestals.addAll(sourcePedestals);
        this.targetPedestal = targetPedestal;
        this.resultPedestal = resultPedestal;
    }

    public void onTargetPedestalContentChange(ReformationTargetPedestalBlockEntity pedestal) {
        this.hasTargetItem = !pedestal.inputInventory.getStackInSlot(0).isEmpty();
    }

    public void onSourcePedestalContentChange(ReformationSourcePedestalBlockEntity pedestal) {
        this.sourcePedestalsWithContents.clear();
        this.hasSourceItems = this.sourcePedestals.stream().map(p -> new Pair(p, (Object)this.level.getBlockEntity(p.getBlockPos()))).filter(p -> p.getSecond() instanceof ReformationSourcePedestalBlockEntity).map(p -> new Pair((Object)((SulfuricFluxEmitterSelectedPoint)p.getFirst()), (Object)((ReformationSourcePedestalBlockEntity)((Object)((Object)p.getSecond()))))).filter(p -> !((ReformationSourcePedestalBlockEntity)((Object)((Object)p.getSecond()))).inputInventory.getStackInSlot(0).isEmpty()).peek(p -> this.sourcePedestalsWithContents.add((SulfuricFluxEmitterSelectedPoint)p.getFirst())).count() > 0L;
        this.setChanged();
    }

    public class MercuryFluxStorage
    extends DefaultMercuryFluxStorage {
        public MercuryFluxStorage(int capacity) {
            super(capacity);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (received > 0) {
                SulfuricFluxEmitterBlockEntity.this.setChanged();
            }
            return received;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (extracted > 0) {
                SulfuricFluxEmitterBlockEntity.this.setChanged();
            }
            return extracted;
        }
    }

    public static class DistHelper {
        static void sendTargetProjectile(SulfuricFluxEmitterBlockEntity emitter) {
            Vec3 normal = Vec3.atLowerCornerOf((Vec3i)((Direction)emitter.getBlockState().getValue((Property)BlockStateProperties.FACING)).getNormal());
            Vec3 from = Vec3.atCenterOf((Vec3i)emitter.getBlockPos()).subtract(normal.scale(0.5));
            Vec3 to = Vec3.atCenterOf((Vec3i)emitter.targetPedestal.getBlockPos()).add(0.0, 0.5, 0.0);
            if (emitter.level.isLoaded(BlockPos.containing((Position)to)) && emitter.level.isLoaded(BlockPos.containing((Position)from)) && ((SulfuricFluxEmitterBlockEntity)emitter).level.isClientSide) {
                FollowProjectile projectile = new FollowProjectile(emitter.level, from, to, new Color(0xFFFFFF, false), new Color(255, false), 0.1f, 0.3f, targetProjectile -> DistHelper.sendSourceProjectiles(targetProjectile, emitter));
                projectile.setDeltaMovement(normal.scale((double)0.3f));
                EntityUtil.spawnEntityClientSide(emitter.level, (Entity)projectile);
            }
        }

        static void sendSourceProjectiles(FollowProjectile targetProjectile, SulfuricFluxEmitterBlockEntity emitter) {
            for (SulfuricFluxEmitterSelectedPoint sourcePedestal : emitter.sourcePedestalsWithContents) {
                Vec3 from = targetProjectile.position();
                Vec3 to = Vec3.atCenterOf((Vec3i)sourcePedestal.getBlockPos()).add(0.0, 0.7, 0.0);
                Vec3 normal = targetProjectile.to().subtract(targetProjectile.from()).normalize();
                if (!emitter.level.isLoaded(BlockPos.containing((Position)to)) || !emitter.level.isLoaded(BlockPos.containing((Position)from))) continue;
                FollowProjectile projectile = new FollowProjectile(emitter.level, from, to, new Color(255, false), new Color(0xFF00FF, false), 0.1f, 0.3f, sourceProjectile -> DistHelper.sendResultProjectile(sourceProjectile, emitter));
                projectile.setDeltaMovement(normal.scale((double)0.3f));
                EntityUtil.spawnEntityClientSide(emitter.level, (Entity)projectile);
            }
        }

        static void sendResultProjectile(FollowProjectile sourceProjectile, SulfuricFluxEmitterBlockEntity emitter) {
            Vec3 from = sourceProjectile.position();
            Vec3 to = Vec3.atCenterOf((Vec3i)emitter.resultPedestal.getBlockPos()).add(0.0, 0.7, 0.0);
            Vec3 normal = sourceProjectile.to().subtract(sourceProjectile.from()).normalize();
            if (emitter.level.isLoaded(BlockPos.containing((Position)to)) && emitter.level.isLoaded(BlockPos.containing((Position)from))) {
                FollowProjectile projectile = new FollowProjectile(emitter.level, from, to, new Color(0xAA08AA, false), new Color(65280, false), 0.1f, 1.0f);
                projectile.setDeltaMovement(normal.scale((double)0.3f));
                EntityUtil.spawnEntityClientSide(emitter.level, (Entity)projectile);
            }
        }
    }
}

