/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.klikli_dev.theurgy.content.behaviour.crafting.CraftingBehaviour;
import com.klikli_dev.theurgy.content.capability.MercuryFluxStorage;
import com.klikli_dev.theurgy.content.recipe.ReformationRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ReformationArrayRecipeInput;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ReformationArrayCraftingBehaviour
extends CraftingBehaviour<ReformationArrayRecipeInput, ReformationRecipe, RecipeManager.CachedCheck<ReformationArrayRecipeInput, ReformationRecipe>> {
    protected final Supplier<MercuryFluxStorage> mercuryFluxStorageSupplier;

    public ReformationArrayCraftingBehaviour(BlockEntity blockEntity, Supplier<ReformationArrayRecipeInput> recipeWrapperSupplier, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<MercuryFluxStorage> mercuryFluxStorageSupplier) {
        super(blockEntity, recipeWrapperSupplier, inputInventorySupplier, outputInventorySupplier, RecipeManager.createCheck((RecipeType)((RecipeType)RecipeTypeRegistry.REFORMATION.get())));
        this.mercuryFluxStorageSupplier = mercuryFluxStorageSupplier;
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(0))) {
            return true;
        }
        return this.recipeCachedCheck.getRecipeFor((RecipeInput)((ReformationArrayRecipeInput)this.recipeWrapperSupplier.get()), this.blockEntity.getLevel()).isPresent();
    }

    @Override
    protected boolean craft(RecipeHolder<ReformationRecipe> pRecipe) {
        ReformationArrayRecipeInput ItemHandlerRecipeInput2 = (ReformationArrayRecipeInput)this.recipeWrapperSupplier.get();
        ItemStack assembledStack = ((ReformationRecipe)pRecipe.value()).assemble(ItemHandlerRecipeInput2, (HolderLookup.Provider)this.blockEntity.getLevel().registryAccess());
        this.mercuryFluxStorageSupplier.get().extractEnergy(((ReformationRecipe)pRecipe.value()).getMercuryFlux(), false);
        HashSet<IItemHandlerModifiable> usedInventories = new HashSet<IItemHandlerModifiable>();
        block0: for (Ingredient source : ((ReformationRecipe)pRecipe.value()).getSources()) {
            for (IItemHandlerModifiable sourceInventory : ItemHandlerRecipeInput2.getSourcePedestalInvs()) {
                ItemStack sourceStack;
                if (usedInventories.contains(sourceInventory) || !source.test(sourceStack = sourceInventory.getStackInSlot(0))) continue;
                usedInventories.add(sourceInventory);
                sourceInventory.extractItem(0, 1, false);
                continue block0;
            }
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)false);
        return true;
    }

    @Override
    protected int getIngredientCount(RecipeHolder<ReformationRecipe> recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(RecipeHolder<ReformationRecipe> recipe) {
        return ((ReformationRecipe)recipe.value()).getTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 100;
    }

    @Override
    protected int getTotalTime() {
        return this.recipeWrapperSupplier.get() != null ? super.getTotalTime() : this.getDefaultCraftingTime();
    }
}

