/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.logisticsitemconnector.inserter;

import com.klikli_dev.theurgy.content.behaviour.logistics.InserterNodeBehaviour;
import com.klikli_dev.theurgy.logistics.Logistics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class LogisticsItemInserterBehaviour
extends InserterNodeBehaviour<IItemHandler, Direction> {
    private Direction directionOverride = null;
    private boolean enabled = true;

    public LogisticsItemInserterBehaviour(BlockEntity blockEntity) {
        super(blockEntity, Capabilities.ItemHandler.BLOCK);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void enabled(boolean enabled) {
        this.enabled = enabled;
        this.onEnabledChanged();
    }

    public void directionOverride(Direction directionOverride) {
        this.directionOverride = directionOverride;
        this.targetCapabilities.forEach(c -> this.onCapabilityInvalidated(c.pos(), this, true));
        this.targetCapabilities = this.buildTargetCapabilities(this.targets());
        this.targetCapabilities.forEach(x$0 -> this.notifyTargetCapabilityCacheCreated(x$0));
    }

    public Direction directionOverride() {
        return this.directionOverride;
    }

    protected void onEnabledChanged() {
        if (this.enabled) {
            Logistics.get().add(this);
        } else {
            Logistics.get().remove(this, false);
        }
    }

    @Override
    @Nullable
    public Direction getTargetContext(BlockPos targetPos) {
        return this.directionOverride != null ? this.directionOverride : (Direction)this.blockEntity.getBlockState().getValue((Property)BlockStateProperties.FACING);
    }

    @Override
    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
    }

    @Override
    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
    }

    @Override
    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.writeNetwork(pTag, pRegistries);
        pTag.putBoolean("enabled", this.enabled);
        if (this.directionOverride != null) {
            pTag.putInt("directionOverride", this.directionOverride.get3DDataValue());
        }
    }

    @Override
    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.readNetwork(pTag, pRegistries);
        if (pTag.contains("directionOverride")) {
            this.directionOverride = Direction.from3DDataValue((int)pTag.getInt("directionOverride"));
        }
        if (pTag.contains("enabled")) {
            this.enabled = pTag.getBoolean("enabled");
        }
    }
}

