/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.logisticsitemconnector;

import com.klikli_dev.theurgy.content.apparatus.logisticsitemconnector.LogisticsItemConnectorBlock;
import com.klikli_dev.theurgy.content.behaviour.filter.FilterBehaviour;
import com.klikli_dev.theurgy.content.behaviour.filter.HasFilterBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.HasLeafNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeBehaviour;
import com.klikli_dev.theurgy.content.item.filter.Filter;
import com.klikli_dev.theurgy.content.item.mode.EnabledSetter;
import com.klikli_dev.theurgy.content.item.mode.TargetDirectionSetter;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class LogisticsItemConnectorBlockEntity
extends BlockEntity
implements HasLeafNodeBehaviour<IItemHandler, Direction>,
HasFilterBehaviour,
TargetDirectionSetter,
EnabledSetter {
    protected LeafNodeBehaviour<IItemHandler, @Nullable Direction> leafNodeBehaviour;
    protected FilterBehaviour filterBehaviour = new FilterBehaviour(this).withCallback(filter -> {
        this.updateBlockStateToMatchFilter();
        this.leafNode().filter((Filter)filter);
    });

    protected LogisticsItemConnectorBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Override
    public FilterBehaviour filter() {
        return this.filterBehaviour;
    }

    @Override
    public List<Pair<BlockPos, Integer>> getStatusHighlights() {
        if (this.level.isClientSide()) {
            return List.of();
        }
        ArrayList<Pair<BlockPos, Integer>> result = new ArrayList<Pair<BlockPos, Integer>>();
        List<BlockPos> targets = this.leafNode().targets();
        for (BlockPos target : targets) {
            result.add((Pair<BlockPos, Integer>)Pair.of((Object)target, (Object)65535));
        }
        return result;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.leafNode().onLoad();
            this.updateBlockStateToMatchFilter();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.level.isClientSide) {
            this.leafNode().onChunkUnload();
        }
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.leafNode().loadAdditional(pTag, pRegistries);
        this.filter().loadAdditional(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        this.leafNode().saveAdditional(pTag, pRegistries);
        this.filter().saveAdditional(pTag, pRegistries);
    }

    @Override
    public LeafNodeBehaviour<IItemHandler, @Nullable Direction> leafNode() {
        return this.leafNodeBehaviour;
    }

    protected void updateBlockStateToMatchFilter() {
        boolean isEmpty;
        boolean bl = isEmpty = (Boolean)this.getBlockState().getValue((Property)LogisticsItemConnectorBlock.HAS_FILTER) == false;
        if (this.filter().filter().isEmpty() != isEmpty) {
            BlockState newState = (BlockState)this.getBlockState().setValue((Property)LogisticsItemConnectorBlock.HAS_FILTER, (Comparable)Boolean.valueOf(!this.filter().filter().isEmpty()));
            this.level.setBlock(this.getBlockPos(), newState, 3);
        }
    }
}

