/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron;

import com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.LiquefactionCachedCheck;
import com.klikli_dev.theurgy.content.behaviour.crafting.CraftingBehaviour;
import com.klikli_dev.theurgy.content.recipe.LiquefactionRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class LiquefactionCraftingBehaviour
extends CraftingBehaviour<ItemHandlerWithFluidRecipeInput, LiquefactionRecipe, LiquefactionCachedCheck> {
    protected Supplier<IFluidHandler> solventTankSupplier;

    public LiquefactionCraftingBehaviour(BlockEntity blockEntity, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<IFluidHandler> solventTankSupplier) {
        super(blockEntity, Lazy.of(() -> new ItemHandlerWithFluidRecipeInput((IItemHandlerModifiable)inputInventorySupplier.get(), (IFluidHandler)solventTankSupplier.get())), inputInventorySupplier, outputInventorySupplier, new LiquefactionCachedCheck((RecipeType<LiquefactionRecipe>)((RecipeType)RecipeTypeRegistry.LIQUEFACTION.get())));
        this.solventTankSupplier = solventTankSupplier;
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(0))) {
            return true;
        }
        return ((LiquefactionCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.getLevel()).isPresent();
    }

    @Override
    protected int getIngredientCount(RecipeHolder<LiquefactionRecipe> recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(RecipeHolder<LiquefactionRecipe> recipe) {
        return ((LiquefactionRecipe)recipe.value()).getTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 100;
    }

    @Override
    protected boolean craft(RecipeHolder<LiquefactionRecipe> pRecipe) {
        if (!super.craft(pRecipe)) {
            return false;
        }
        this.solventTankSupplier.get().drain(((LiquefactionRecipe)pRecipe.value()).getSolventAmount(), IFluidHandler.FluidAction.EXECUTE);
        return true;
    }
}

