/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.fermentationvat;

import com.klikli_dev.theurgy.content.recipe.FermentationRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class FermentationCachedCheck
implements RecipeManager.CachedCheck<ItemHandlerWithFluidRecipeInput, FermentationRecipe> {
    private final RecipeType<FermentationRecipe> type;
    private final RecipeManager.CachedCheck<ItemHandlerWithFluidRecipeInput, FermentationRecipe> internal;
    @Nullable
    private ResourceLocation lastRecipe;

    public FermentationCachedCheck(RecipeType<FermentationRecipe> type) {
        this.type = type;
        this.internal = RecipeManager.createCheck(type);
    }

    private Optional<RecipeHolder<FermentationRecipe>> getRecipeFor(ItemStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        RecipeHolder recipe;
        RecipeManager recipeManager = level.getRecipeManager();
        if (lastRecipe != null && (recipe = recipeManager.byKeyTyped(this.type, lastRecipe)) != null && ((FermentationRecipe)recipe.value()).getIngredients().stream().anyMatch(i -> i.test(stack))) {
            return Optional.of(recipe);
        }
        return recipeManager.byType(this.type).stream().filter(entry -> ((FermentationRecipe)entry.value()).getIngredients().stream().anyMatch(i -> i.test(stack))).findFirst();
    }

    private Optional<RecipeHolder<FermentationRecipe>> getRecipeFor(FluidStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        RecipeHolder recipe;
        RecipeManager recipeManager = level.getRecipeManager();
        if (lastRecipe != null && (recipe = recipeManager.byKeyTyped(this.type, lastRecipe)) != null && ((FermentationRecipe)recipe.value()).getFluid().test(stack)) {
            return Optional.of(recipe);
        }
        return recipeManager.byType(this.type).stream().filter(entry -> ((FermentationRecipe)entry.value()).getFluid().test(stack)).findFirst();
    }

    public Optional<RecipeHolder<FermentationRecipe>> getRecipeFor(ItemStack stack, Level level) {
        Optional<RecipeHolder<FermentationRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipe);
        if (optional.isPresent()) {
            RecipeHolder<FermentationRecipe> recipeHolder = optional.get();
            this.lastRecipe = recipeHolder.id();
            return optional;
        }
        return Optional.empty();
    }

    public Optional<RecipeHolder<FermentationRecipe>> getRecipeFor(FluidStack stack, Level level) {
        Optional<RecipeHolder<FermentationRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipe);
        if (optional.isPresent()) {
            RecipeHolder<FermentationRecipe> recipeHolder = optional.get();
            this.lastRecipe = recipeHolder.id();
            return optional;
        }
        return Optional.empty();
    }

    public Optional<RecipeHolder<FermentationRecipe>> getRecipeFor(ItemHandlerWithFluidRecipeInput container, Level level) {
        Optional recipe = this.internal.getRecipeFor((RecipeInput)container, level);
        if (recipe.isPresent()) {
            this.lastRecipe = ((RecipeHolder)recipe.get()).id();
        }
        return recipe;
    }
}

