/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.digestionvat;

import com.klikli_dev.theurgy.content.apparatus.digestionvat.DigestionCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.storage.StorageBehaviour;
import com.klikli_dev.theurgy.content.storage.MonitoredFluidTank;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.content.storage.PreventInsertExtractFluidWrapper;
import com.klikli_dev.theurgy.content.storage.PreventInsertExtractWrapper;
import com.klikli_dev.theurgy.content.storage.PreventInsertWrapper;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class DigestionStorageBehaviour
extends StorageBehaviour<DigestionStorageBehaviour> {
    public ItemStackHandler inputInventory;
    public IItemHandler inputInventoryReadOnlyWrapper;
    public ItemStackHandler outputInventory;
    public IItemHandlerModifiable outputInventoryExtractOnlyWrapper;
    public IItemHandler outputInventoryReadOnlyWrapper;
    public CombinedInvWrapper inventory;
    public IItemHandler inventoryReadOnlyWrapper;
    public FluidTank fluidTank;
    public IFluidHandler fluidTankReadOnlyWrapper;
    public Supplier<DigestionCraftingBehaviour> craftingBehaviour;

    public DigestionStorageBehaviour(BlockEntity blockEntity, Supplier<DigestionCraftingBehaviour> craftingBehaviour) {
        super(blockEntity);
        this.craftingBehaviour = craftingBehaviour;
        this.inputInventory = new InputInventory();
        this.inputInventoryReadOnlyWrapper = new PreventInsertExtractWrapper((IItemHandlerModifiable)this.inputInventory);
        this.outputInventory = new OutputInventory();
        this.outputInventoryExtractOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
        this.outputInventoryReadOnlyWrapper = new PreventInsertExtractWrapper((IItemHandlerModifiable)this.outputInventory);
        this.inventory = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventoryExtractOnlyWrapper});
        this.inventoryReadOnlyWrapper = new PreventInsertExtractWrapper((IItemHandlerModifiable)this.inventory);
        this.fluidTank = new WaterTank(10000, f -> this.craftingBehaviour.get().canProcess((FluidStack)f));
        this.fluidTankReadOnlyWrapper = new PreventInsertExtractFluidWrapper((IFluidHandler)this.fluidTank);
    }

    @Override
    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (pTag.contains("inputInventory")) {
            this.inputInventory.deserializeNBT(pRegistries, pTag.getCompound("inputInventory"));
        }
        if (pTag.contains("outputInventory")) {
            this.outputInventory.deserializeNBT(pRegistries, pTag.getCompound("outputInventory"));
        }
        if (pTag.contains("fluidTank")) {
            this.fluidTank.readFromNBT(pRegistries, pTag.getCompound("fluidTank"));
        }
    }

    @Override
    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("inputInventory", (Tag)this.inputInventory.serializeNBT(pRegistries));
        pTag.put("outputInventory", (Tag)this.outputInventory.serializeNBT(pRegistries));
        pTag.put("fluidTank", (Tag)this.fluidTank.writeToNBT(pRegistries, new CompoundTag()));
    }

    @Override
    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.writeNetwork(pTag, pRegistries);
    }

    @Override
    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.readNetwork(pTag, pRegistries);
    }

    public class InputInventory
    extends MonitoredItemStackHandler {
        public InputInventory() {
            super(3);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            DigestionStorageBehaviour.this.craftingBehaviour.get().onInputItemChanged(oldStack, newStack);
            DigestionStorageBehaviour.this.sendBlockUpdated();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (i == slot || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.getStackInSlot(i))) continue;
                return false;
            }
            return DigestionStorageBehaviour.this.craftingBehaviour.get().canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            DigestionStorageBehaviour.this.setChanged();
        }
    }

    public class OutputInventory
    extends MonitoredItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            DigestionStorageBehaviour.this.sendBlockUpdated();
        }

        protected void onContentsChanged(int slot) {
            DigestionStorageBehaviour.this.setChanged();
        }
    }

    public class WaterTank
    extends MonitoredFluidTank {
        public WaterTank(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        protected void onContentsChanged() {
            DigestionStorageBehaviour.this.setChanged();
        }

        @Override
        protected void onContentTypeChanged(FluidStack oldStack, FluidStack newStack) {
            DigestionStorageBehaviour.this.sendBlockUpdated();
        }
    }
}

