/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.digestionvat;

import com.klikli_dev.theurgy.content.recipe.DigestionRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class DigestionCachedCheck
implements RecipeManager.CachedCheck<ItemHandlerWithFluidRecipeInput, DigestionRecipe> {
    private final RecipeType<DigestionRecipe> type;
    private final RecipeManager.CachedCheck<ItemHandlerWithFluidRecipeInput, DigestionRecipe> internal;
    @Nullable
    private ResourceLocation lastRecipe;

    public DigestionCachedCheck(RecipeType<DigestionRecipe> type) {
        this.type = type;
        this.internal = RecipeManager.createCheck(type);
    }

    private Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(ItemStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        RecipeHolder recipe;
        RecipeManager recipeManager = level.getRecipeManager();
        if (lastRecipe != null && (recipe = recipeManager.byKeyTyped(this.type, lastRecipe)) != null && ((DigestionRecipe)recipe.value()).getIngredients().stream().anyMatch(i -> i.test(stack))) {
            return Optional.of(recipe);
        }
        return recipeManager.byType(this.type).stream().filter(entry -> ((DigestionRecipe)entry.value()).getIngredients().stream().anyMatch(i -> i.test(stack))).findFirst();
    }

    private Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(FluidStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        RecipeHolder recipe;
        RecipeManager recipeManager = level.getRecipeManager();
        if (lastRecipe != null && (recipe = recipeManager.byKeyTyped(this.type, lastRecipe)) != null && ((DigestionRecipe)recipe.value()).getFluid().test(stack)) {
            return Optional.of(recipe);
        }
        return recipeManager.byType(this.type).stream().filter(entry -> ((DigestionRecipe)entry.value()).getFluid().test(stack)).findFirst();
    }

    public Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(ItemStack stack, Level level) {
        Optional<RecipeHolder<DigestionRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipe);
        if (optional.isPresent()) {
            RecipeHolder<DigestionRecipe> recipeHolder = optional.get();
            this.lastRecipe = recipeHolder.id();
            return optional;
        }
        return Optional.empty();
    }

    public Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(FluidStack stack, Level level) {
        Optional<RecipeHolder<DigestionRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipe);
        if (optional.isPresent()) {
            RecipeHolder<DigestionRecipe> recipeHolder = optional.get();
            this.lastRecipe = recipeHolder.id();
            return optional;
        }
        return Optional.empty();
    }

    public Optional<RecipeHolder<DigestionRecipe>> getRecipeFor(ItemHandlerWithFluidRecipeInput container, Level level) {
        Optional recipe = this.internal.getRecipeFor((RecipeInput)container, level);
        if (recipe.isPresent()) {
            this.lastRecipe = ((RecipeHolder)recipe.get()).id();
        }
        return recipe;
    }
}

