/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter;

import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterBlock;
import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.content.behaviour.selection.SelectionBehaviour;
import com.klikli_dev.theurgy.content.capability.DefaultMercuryFluxStorage;
import com.klikli_dev.theurgy.content.capability.HeatReceiver;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageShowCaloricFlux;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.mojang.serialization.DynamicOps;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CaloricFluxEmitterBlockEntity
extends BlockEntity {
    public static final int CAPACITY = 1000;
    public static final int FLUX_PER_HEAT = 100;
    public static final int HEAT_TARGET_FOR_TICKS = 120;
    public static final int TICK_INTERVAL = 20;
    public MercuryFluxStorage mercuryFluxStorage = new MercuryFluxStorage(1000);
    protected List<CaloricFluxEmitterSelectedPoint> selectedPoints = new ArrayList<CaloricFluxEmitterSelectedPoint>();

    public CaloricFluxEmitterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.CALORIC_FLUX_EMITTER.get(), pPos, pBlockState);
    }

    public void onLoad() {
        this.selectedPoints.forEach(point -> point.setLevel(this.getLevel()));
    }

    public void tickServer() {
        if (this.getLevel().getGameTime() % 20L != 0L) {
            return;
        }
        if (!((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            return;
        }
        if (this.selectedPoints.isEmpty()) {
            return;
        }
        CaloricFluxEmitterSelectedPoint selectedPoint = this.selectedPoints.get(0);
        if (!this.getSelectionBehaviour().isValid(selectedPoint)) {
            return;
        }
        if (this.mercuryFluxStorage.getEnergyStored() >= 100) {
            HeatReceiver heatReceiver = (HeatReceiver)this.level.getCapability(CapabilityRegistry.HEAT_RECEIVER, selectedPoint.getBlockPos(), null);
            if (heatReceiver.getIsHotUntil() > this.getLevel().getGameTime() + 20L) {
                return;
            }
            this.mercuryFluxStorage.extractEnergy(100, false);
            heatReceiver.setHotUntil(this.getLevel().getGameTime() + 120L);
            Networking.sendToTracking((ServerLevel)this.getLevel(), new ChunkPos(this.getBlockPos()), new MessageShowCaloricFlux(this.getBlockPos(), selectedPoint.getBlockPos(), (Direction)this.getBlockState().getValue((Property)CaloricFluxEmitterBlock.FACING)));
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("mercuryFluxStorage", this.mercuryFluxStorage.serializeNBT(pRegistries));
        pTag.put("selectedPoints", (Tag)CaloricFluxEmitterSelectedPoint.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.selectedPoints).getOrThrow(e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.selectedPoints))));
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("mercuryFluxStorage")) {
            this.mercuryFluxStorage.deserializeNBT(pRegistries, pTag.get("mercuryFluxStorage"));
        }
        if (pTag.contains("selectedPoints")) {
            this.selectedPoints = (List)CaloricFluxEmitterSelectedPoint.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.get("selectedPoints")).getOrThrow(e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.get("selectedPoints"))));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        if (pComponentInput.get(DataComponentRegistry.MERCURY_FLUX_STORAGE) != null) {
            this.mercuryFluxStorage.setEnergyStored((Integer)pComponentInput.get(DataComponentRegistry.MERCURY_FLUX_STORAGE));
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentRegistry.MERCURY_FLUX_STORAGE, (Object)this.mercuryFluxStorage.getEnergyStored());
    }

    public SelectionBehaviour<CaloricFluxEmitterSelectedPoint> getSelectionBehaviour() {
        return ((CaloricFluxEmitterBlock)((Object)BlockRegistry.CALORIC_FLUX_EMITTER.get())).selectionBehaviour();
    }

    public void setSelectedPoints(List<CaloricFluxEmitterSelectedPoint> selectedPoints) {
        this.selectedPoints = selectedPoints;
        this.selectedPoints.removeIf(p -> !p.getBlockPos().closerThan((Vec3i)this.getBlockPos(), (double)this.getSelectionBehaviour().getBlockRange()));
        this.setChanged();
    }

    public class MercuryFluxStorage
    extends DefaultMercuryFluxStorage {
        public MercuryFluxStorage(int capacity) {
            super(capacity);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (received > 0) {
                CaloricFluxEmitterBlockEntity.this.setChanged();
            }
            return received;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (extracted > 0) {
                CaloricFluxEmitterBlockEntity.this.setChanged();
            }
            return extracted;
        }
    }
}

