/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.core;

import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.encryption.Encryptor;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;

public class EncryptionUtil {
    public static Optional<Component> tryDecrypt(Component component) {
        Optional<Encryptor<?>> optional = NCRConfig.getEncryption().getEncryptor();
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        Encryptor<?> encryption = optional.get();
        Component copy = EncryptionUtil.recreate(component);
        ComponentContents contents = copy.getContents();
        return Optional.ofNullable(EncryptionUtil.tryDecrypt(copy, encryption) ? copy : null);
    }

    public static boolean tryDecrypt(Component component, Encryptor<?> encryptor) {
        boolean decryptedSiblings = false;
        for (Component sibling : component.getSiblings()) {
            if (!EncryptionUtil.tryDecrypt(sibling, encryptor)) continue;
            decryptedSiblings = true;
        }
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof PlainTextContents.LiteralContents) {
            PlainTextContents.LiteralContents literal = (PlainTextContents.LiteralContents)componentContents;
            decrypted = EncryptionUtil.tryDecrypt(literal.text(), encryptor);
            if (((Optional)decrypted).isPresent()) {
                ((MutableComponent)component).contents = new PlainTextContents.LiteralContents((String)((Optional)decrypted).get());
                return true;
            }
        } else {
            decrypted = component.getContents();
            if (decrypted instanceof TranslatableContents) {
                TranslatableContents translatable = (TranslatableContents)decrypted;
                for (int i = 0; i < translatable.args.length; ++i) {
                    String str;
                    Optional<String> decrypted;
                    Object arg = translatable.args[i];
                    if (arg instanceof MutableComponent) {
                        MutableComponent mutable = (MutableComponent)arg;
                        if (!EncryptionUtil.tryDecrypt((Component)mutable, encryptor)) continue;
                        decryptedSiblings = true;
                        continue;
                    }
                    if (!(arg instanceof String) || !(decrypted = EncryptionUtil.tryDecrypt(str = (String)arg, encryptor)).isPresent()) continue;
                    translatable.args[i] = decrypted.get();
                    decryptedSiblings = true;
                }
            }
        }
        return decryptedSiblings;
    }

    public static Optional<String> tryDecrypt(String message, Encryptor<?> encryptor) {
        try {
            String[] stringArray;
            String messageCopy = message.replace('\uff1a', ' ');
            if (messageCopy.contains(" ")) {
                stringArray = messageCopy.split(" ");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = messageCopy;
            }
            String[] splat = stringArray;
            String decryptable = splat[splat.length - 1];
            String decrypted = encryptor.decrypt(decryptable);
            if (decrypted.startsWith("#%")) {
                return Optional.of(message.substring(0, message.length() - decryptable.length()) + decrypted.substring(2, decrypted.length()));
            }
            return Optional.empty();
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    public static Component recreate(Component component) {
        return Component.Serializer.fromJson((String)Component.Serializer.toJson((Component)component, (HolderLookup.Provider)RegistryAccess.EMPTY), (HolderLookup.Provider)RegistryAccess.EMPTY);
    }
}

