/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingFallEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.forgivingvoid.ForgivingVoidConfig;
import net.blay09.mods.forgivingvoid.ForgivingVoidFallThroughEvent;
import net.blay09.mods.forgivingvoid.mixin.ServerGamePacketListenerImplAccessor;
import net.blay09.mods.forgivingvoid.mixin.ServerPlayerAccessor;
import net.blay09.mods.forgivingvoid.mixin.ThrownTridentAccessor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ForgivingVoid {
    public static final String MOD_ID = "forgivingvoid";
    public static final Set<Block> FALL_CATCHING_BLOCKS = Set.of(Blocks.COBWEB);

    public static void initialize() {
        ForgivingVoidConfig.initialize();
        Balm.getEvents().onEvent(LivingFallEvent.class, ForgivingVoid::onLivingEntityFall);
        Set<ResourceLocation> entityAllowList = ForgivingVoidConfig.getActive().entityAllowList;
        boolean onlyPlayersExplicitlyAllowed = entityAllowList.isEmpty() || entityAllowList.size() == 1 && entityAllowList.contains(ResourceLocation.withDefaultNamespace((String)"player"));
        boolean otherEntitiesImplicitlyAllowed = ForgivingVoidConfig.getActive().tridentForgiveness;
        if (onlyPlayersExplicitlyAllowed && !otherEntitiesImplicitlyAllowed) {
            Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.Start, ForgivingVoid::onPlayerTick);
        } else {
            Balm.getEvents().onTickEvent(TickType.Entity, TickPhase.Start, ForgivingVoid::onEntityTick);
        }
    }

    public static void onPlayerTick(ServerPlayer player) {
        ForgivingVoid.onEntityTick((Entity)player);
    }

    /*
     * Unable to fully structure code
     */
    public static void onEntityTick(Entity entity) {
        if (!ForgivingVoid.isAllowedEntity(entity)) {
            return;
        }
        triggerAtY = entity.level().getMinBuildHeight() - ForgivingVoidConfig.getActive().triggerAtDistanceBelow;
        v0 = isInVoid = entity.getY() < (double)triggerAtY && entity.yo < (double)triggerAtY;
        if (!(entity instanceof ServerPlayer)) ** GOTO lbl-1000
        player = (ServerPlayer)entity;
        if (((ServerGamePacketListenerImplAccessor)player.connection).getAwaitingPositionFromClient() != null) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isTeleporting = v1;
        persistentData = Balm.getHooks().getPersistentData(entity);
        if (isInVoid && !isTeleporting && ForgivingVoid.isEnabledForDimension((ResourceKey<Level>)entity.level().dimension()) && ForgivingVoid.fireForgivingVoidEvent(entity)) {
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60, 3));
            }
            if (entity.isVehicle()) {
                entity.ejectPassengers();
            }
            entity.stopRiding();
            if (entity instanceof ServerPlayerAccessor) {
                player = (ServerPlayerAccessor)entity;
                player.setIsChangingDimension(true);
            }
            entity.teleportTo(entity.getX(), (double)ForgivingVoidConfig.getActive().fallingHeight, entity.getZ());
            persistentData.putBoolean("ForgivingVoidIsFalling", true);
        } else if (persistentData.getBoolean("ForgivingVoidIsFalling")) {
            if (ForgivingVoid.hasLanded(entity) || ForgivingVoid.isOrMayFly(entity)) {
                persistentData.putBoolean("ForgivingVoidIsFalling", false);
                if (entity instanceof ServerPlayerAccessor) {
                    player = (ServerPlayerAccessor)entity;
                    player.setIsChangingDimension(false);
                }
                return;
            }
            if (ForgivingVoidConfig.getActive().disableVanillaAntiCheatWhileFalling && entity instanceof ServerPlayerAccessor) {
                player = (ServerPlayerAccessor)entity;
                player.setIsChangingDimension(true);
            }
        }
    }

    private static boolean isAllowedEntity(Entity entity) {
        ThrownTrident trident;
        Byte loyalty;
        Set<ResourceLocation> entityAllowList = ForgivingVoidConfig.getActive().entityAllowList;
        ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        if (entityAllowList.isEmpty() && entity instanceof Player) {
            return true;
        }
        if (ForgivingVoidConfig.getActive().tridentForgiveness && entity instanceof ThrownTrident && (loyalty = (Byte)(trident = (ThrownTrident)entity).getEntityData().get(ThrownTridentAccessor.getIdLoyalty())) > 0) {
            return true;
        }
        return entityAllowList.contains(entityId);
    }

    private static boolean hasLanded(Entity entity) {
        if (entity.onGround() || entity.isInWater() || entity.isInLava()) {
            return true;
        }
        BlockState landedOnState = entity.level().getBlockState(entity.blockPosition());
        return FALL_CATCHING_BLOCKS.contains(landedOnState.getBlock());
    }

    private static boolean isOrMayFly(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        return player.getAbilities().flying || player.getAbilities().mayfly;
    }

    public static void onLivingEntityFall(LivingFallEvent event) {
        CompoundTag persistentData;
        LivingEntity entity = event.getEntity();
        if (ForgivingVoid.isAllowedEntity((Entity)entity) && (persistentData = Balm.getHooks().getPersistentData((Entity)entity)).getBoolean("ForgivingVoidIsFalling")) {
            float damage = ForgivingVoidConfig.getActive().damageOnFall;
            if (ForgivingVoidConfig.getActive().preventDeath && entity.getHealth() - damage <= 0.0f) {
                damage = entity.getHealth() - 1.0f;
            }
            event.setFallDamageOverride(Float.valueOf(damage));
            if (entity instanceof ServerPlayerAccessor) {
                ServerPlayerAccessor player = (ServerPlayerAccessor)entity;
                player.setIsChangingDimension(false);
            }
        }
    }

    private static boolean fireForgivingVoidEvent(Entity entity) {
        ForgivingVoidFallThroughEvent event = new ForgivingVoidFallThroughEvent(entity);
        Balm.getEvents().fireEvent((Object)event);
        return !event.isCanceled();
    }

    private static boolean isEnabledForDimension(ResourceKey<Level> dimensionKey) {
        if (dimensionKey == Level.OVERWORLD) {
            return ForgivingVoidConfig.getActive().triggerInOverworld;
        }
        if (dimensionKey == Level.END) {
            return ForgivingVoidConfig.getActive().triggerInEnd;
        }
        if (dimensionKey == Level.NETHER) {
            return ForgivingVoidConfig.getActive().triggerInNether;
        }
        ResourceLocation dimension = dimensionKey.location();
        Set<ResourceLocation> dimensionAllowList = ForgivingVoidConfig.getActive().dimensionAllowList;
        Set<ResourceLocation> dimensionDenyList = ForgivingVoidConfig.getActive().dimensionDenyList;
        if (!dimensionAllowList.isEmpty() && !dimensionAllowList.contains(dimension)) {
            return false;
        }
        return !dimensionDenyList.contains(dimension);
    }
}

