/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.tile;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import xyz.vsngamer.elevatorid.init.Registry;
import xyz.vsngamer.elevatorid.tile.ElevatorTileEntity;

public class ElevatorContainer
extends AbstractContainerMenu {
    private final Direction playerFacing;
    private ElevatorTileEntity elevatorTile;
    private final BlockPos pos;

    public ElevatorContainer(int id, BlockPos pos, Player player) {
        super(Registry.ELEVATOR_CONTAINER.get(), id);
        BlockEntity tile = player.level().getBlockEntity(pos);
        if (tile instanceof ElevatorTileEntity) {
            this.elevatorTile = (ElevatorTileEntity)tile;
        }
        this.playerFacing = player.getDirection();
        this.pos = pos;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int id) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@Nonnull Player playerIn) {
        return ElevatorContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)playerIn.level(), (BlockPos)this.elevatorTile.getBlockPos()), (Player)playerIn, (Block)this.elevatorTile.getBlockState().getBlock());
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ElevatorTileEntity getTile() {
        return this.elevatorTile;
    }

    public Direction getPlayerFacing() {
        return this.playerFacing;
    }
}

