/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.siteexport.WebPExporter;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OffScreenRenderer
implements AutoCloseable {
    private final NativeImage nativeImage;
    private final TextureTarget fb;
    private final int width;
    private final int height;

    public OffScreenRenderer(int width, int height) {
        this.width = width;
        this.height = height;
        RenderSystem.viewport((int)0, (int)0, (int)width, (int)height);
        this.nativeImage = new NativeImage(width, height, true);
        this.fb = new TextureTarget(width, height, true, true);
        this.fb.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.fb.clear(true);
    }

    @Override
    public void close() {
        this.nativeImage.close();
        this.fb.destroyBuffers();
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            Window window = minecraft.getWindow();
            RenderSystem.viewport((int)0, (int)0, (int)window.getWidth(), (int)window.getHeight());
        }
    }

    public byte[] captureAsPng(Runnable r) {
        this.renderToBuffer(r);
        try {
            return this.nativeImage.asByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to encode image as PNG", e);
        }
    }

    public void captureAsPng(Runnable r, Path path) throws IOException {
        this.renderToBuffer(r);
        this.nativeImage.writeToFile(path);
    }

    public boolean isAnimated(Collection<TextureAtlasSprite> sprites) {
        return sprites.stream().anyMatch(s -> s.contents().animatedTexture != null);
    }

    public byte[] captureAsWebp(Runnable r, Collection<TextureAtlasSprite> sprites, WebPExporter.Format format) {
        List<TextureAtlasSprite> animatedSprites = sprites.stream().filter(sprite -> sprite.contents().animatedTexture != null).toList();
        if (animatedSprites.isEmpty()) {
            return this.captureAsPng(r);
        }
        int maxTime = animatedSprites.stream().mapToInt(s -> s.contents().animatedTexture.frames.stream().mapToInt(value -> value.time).sum()).max().orElse(0);
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        Map<ResourceLocation, List> tickers = animatedSprites.stream().collect(Collectors.groupingBy(TextureAtlasSprite::atlasLocation)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(TextureAtlasSprite::createTicker).toList()));
        for (TextureAtlasSprite sprite2 : animatedSprites) {
            textureManager.getTexture(sprite2.atlasLocation()).bind();
            sprite2.uploadFirstFrame();
        }
        int width = this.nativeImage.getWidth();
        int height = this.nativeImage.getHeight();
        try (WebPExporter webpWriter = new WebPExporter(width, height, format);){
            for (int i = 0; i < maxTime; ++i) {
                for (Map.Entry<ResourceLocation, List> entry : tickers.entrySet()) {
                    textureManager.getTexture(entry.getKey()).bind();
                    for (TextureAtlasSprite.Ticker ticker : entry.getValue()) {
                        ticker.tickAndUpload();
                    }
                }
                this.renderToBuffer(r);
                webpWriter.writeFrame(i, this.nativeImage);
            }
            byte[] byArray = webpWriter.finish();
            return byArray;
        }
    }

    private void renderToBuffer(Runnable r) {
        this.fb.bindWrite(true);
        GlStateManager._clear((int)16640, (boolean)false);
        r.run();
        this.fb.unbindWrite();
        this.fb.bindRead();
        this.nativeImage.downloadTexture(0, false);
        this.nativeImage.flipY();
        this.fb.unbindRead();
    }

    public void setupItemRendering() {
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, 16.0f, 16.0f, 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        Matrix4fStack poseStack = RenderSystem.getModelViewStack();
        poseStack.identity();
        poseStack.translate(0.0f, 0.0f, -11000.0f);
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
        FogRenderer.setupNoFog();
    }

    public void setupOrtographicRendering() {
        float angle = 36.0f;
        float renderHeight = 0.0f;
        float renderScale = 100.0f;
        float rotation = 45.0f;
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().ortho(-1.0f, 1.0f, 1.0f, -1.0f, 1000.0f, 3000.0f), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        Matrix4fStack poseStack = RenderSystem.getModelViewStack();
        poseStack.identity();
        poseStack.translate(0.0f, 0.0f, -2000.0f);
        FogRenderer.setupNoFog();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        poseStack.rotate((Quaternionfc)new Quaternionf().rotationY((float)(-Math.PI)));
        Quaternionf flip = new Quaternionf().rotationZ((float)Math.PI);
        flip.mul((Quaternionfc)new Quaternionf().rotationX((float)Math.PI / 180 * angle));
        poseStack.translate(0.0f, renderHeight / -300.0f, 0.0f);
        poseStack.scale(renderScale * 0.004f, renderScale * 0.004f, 1.0f);
        Quaternionf rotate = new Quaternionf().rotationY((float)Math.PI / 180 * rotation);
        poseStack.rotate((Quaternionfc)flip);
        poseStack.rotate((Quaternionfc)rotate);
        RenderSystem.applyModelViewMatrix();
        Lighting.setupLevel();
    }

    public void setupPerspectiveRendering(float zoom, float fov, Vector3f eyePos, Vector3f lookAt) {
        float aspectRatio = (float)this.width / (float)this.height;
        Matrix4fStack projMat = new Matrix4fStack();
        if (zoom != 1.0f) {
            projMat.scale(zoom, zoom, 1.0f);
        }
        projMat.mul((Matrix4fc)new Matrix4f().perspective(fov, aspectRatio, 0.05f, 16.0f));
        RenderSystem.setProjectionMatrix((Matrix4f)projMat, (VertexSorting)VertexSorting.DISTANCE_TO_ORIGIN);
        Matrix4fStack poseStack = RenderSystem.getModelViewStack();
        poseStack.identity();
        Matrix4f vm = OffScreenRenderer.createViewMatrix(eyePos, lookAt);
        poseStack.mul((Matrix4fc)vm);
        RenderSystem.applyModelViewMatrix();
        Lighting.setupLevel();
    }

    private static Matrix4f createViewMatrix(Vector3f eyePos, Vector3f lookAt) {
        Vector3f dir = new Vector3f((Vector3fc)lookAt);
        dir.sub((Vector3fc)eyePos);
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        dir.normalize();
        Vector3f right = new Vector3f((Vector3fc)dir);
        right.cross((Vector3fc)up);
        right.normalize();
        up = new Vector3f((Vector3fc)right);
        up.cross((Vector3fc)dir);
        up.normalize();
        Matrix4f viewMatrix = new Matrix4f();
        viewMatrix.setTransposed(FloatBuffer.wrap(new float[]{right.x(), right.y(), right.z(), 0.0f, up.x(), up.y(), up.z(), 0.0f, -dir.x(), -dir.y(), -dir.z(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}));
        viewMatrix.translate(-eyePos.x(), -eyePos.y(), -eyePos.z());
        return viewMatrix;
    }
}

