/*
 * Decompiled with CFR 0.152.
 */
package appeng.init;

import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.items.parts.FacadeItem;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.entropy.EntropyRecipeSerializer;
import appeng.recipes.game.FacadeRecipe;
import appeng.recipes.game.StorageCellUpgradeRecipe;
import appeng.recipes.game.StorageCellUpgradeRecipeSerializer;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.ChargerRecipeSerializer;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.handlers.InscriberRecipeSerializer;
import appeng.recipes.mattercannon.MatterCannonAmmo;
import appeng.recipes.mattercannon.MatterCannonAmmoSerializer;
import appeng.recipes.transform.TransformRecipe;
import appeng.recipes.transform.TransformRecipeSerializer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public final class InitRecipeSerializers {
    private InitRecipeSerializers() {
    }

    public static void init(Registry<RecipeSerializer<?>> registry) {
        FacadeItem facadeItem = AEItems.FACADE.asItem();
        InitRecipeSerializers.register(registry, InscriberRecipe.TYPE_ID, InscriberRecipeSerializer.INSTANCE);
        InitRecipeSerializers.register(registry, AppEng.makeId("facade"), FacadeRecipe.getSerializer(facadeItem));
        InitRecipeSerializers.register(registry, EntropyRecipe.TYPE_ID, EntropyRecipeSerializer.INSTANCE);
        InitRecipeSerializers.register(registry, MatterCannonAmmo.TYPE_ID, MatterCannonAmmoSerializer.INSTANCE);
        InitRecipeSerializers.register(registry, TransformRecipe.TYPE_ID, TransformRecipeSerializer.INSTANCE);
        InitRecipeSerializers.register(registry, ChargerRecipe.TYPE_ID, ChargerRecipeSerializer.INSTANCE);
        InitRecipeSerializers.register(registry, StorageCellUpgradeRecipe.SERIALIZER_ID, StorageCellUpgradeRecipeSerializer.INSTANCE);
    }

    private static void register(Registry<RecipeSerializer<?>> registry, ResourceLocation id, RecipeSerializer<?> serializer) {
        Registry.register(registry, (ResourceLocation)id, serializer);
    }
}

