/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.tags;

import appeng.api.ids.AEComponents;
import appeng.datagen.providers.tags.ConventionTags;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class DataComponentTypeTagProvider
extends TagsProvider<DataComponentType<?>> {
    public DataComponentTypeTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, Registries.DATA_COMPONENT_TYPE, registries, "ae2", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider registries) {
        IdentityHashMap<DataComponentType, ResourceKey> componentKeys = new IdentityHashMap<DataComponentType, ResourceKey>();
        for (DeferredHolder entry : AEComponents.DR.getEntries()) {
            componentKeys.put((DataComponentType)entry.get(), entry.getKey());
        }
        List<DataComponentType> exportedComponents = List.of(AEComponents.EXPORTED_CONFIG_INV, AEComponents.EXPORTED_CUSTOM_NAME, AEComponents.EXPORTED_LEVEL_EMITTER_VALUE, AEComponents.EXPORTED_P2P_FREQUENCY, AEComponents.EXPORTED_P2P_TYPE, AEComponents.EXPORTED_PATTERNS, AEComponents.EXPORTED_PRIORITY, AEComponents.EXPORTED_PUSH_DIRECTION, AEComponents.EXPORTED_SETTINGS, AEComponents.EXPORTED_SETTINGS_SOURCE, AEComponents.EXPORTED_UPGRADES);
        for (DataComponentType exportedComponent : exportedComponents) {
            ResourceKey key = Objects.requireNonNull((ResourceKey)componentKeys.get(exportedComponent));
            this.tag(ConventionTags.EXPORTED_SETTINGS).add(key);
        }
    }
}

