/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.clientbound;

import appeng.core.network.ClientboundPacket;
import appeng.core.network.CustomAppEngPayload;
import appeng.hooks.CompassManager;
import appeng.hooks.CompassResult;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record CompassResponsePacket(long attunement, int cx, int cz, int cdy, CompassResult cr) implements ClientboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, CompassResponsePacket> STREAM_CODEC = StreamCodec.ofMember(CompassResponsePacket::write, CompassResponsePacket::decode);
    public static final CustomPacketPayload.Type<CompassResponsePacket> TYPE = CustomAppEngPayload.createType("compass_response");

    public CustomPacketPayload.Type<CompassResponsePacket> type() {
        return TYPE;
    }

    public static CompassResponsePacket decode(RegistryFriendlyByteBuf stream) {
        long attunement = stream.readLong();
        int cx = stream.readInt();
        int cz = stream.readInt();
        int cdy = stream.readInt();
        CompassResult cr = new CompassResult(stream.readBoolean(), stream.readBoolean(), stream.readDouble());
        return new CompassResponsePacket(attunement, cx, cz, cdy, cr);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeLong(this.attunement);
        data.writeInt(this.cx);
        data.writeInt(this.cz);
        data.writeInt(this.cdy);
        data.writeBoolean(this.cr.isValidResult());
        data.writeBoolean(this.cr.isSpin());
        data.writeDouble(this.cr.getRad());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleOnClient(Player player) {
        CompassManager.INSTANCE.postResult(this.attunement, this.cx << 4, this.cdy << 5, this.cz << 4, this.cr);
    }
}

