/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.definitions;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.util.helpers.ItemComparisonHelper;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemDefinition<T extends Item>
implements ItemLike {
    private final ResourceLocation id;
    private final String englishName;
    private final T item;

    public ItemDefinition(String englishName, ResourceLocation id, T item) {
        Objects.requireNonNull(id, "id");
        this.id = id;
        this.englishName = englishName;
        this.item = item;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public ItemStack stack() {
        return this.stack(1);
    }

    public ItemStack stack(int stackSize) {
        return new ItemStack(this.item, stackSize);
    }

    public GenericStack genericStack(long stackSize) {
        return new GenericStack(AEItemKey.of(this.item), stackSize);
    }

    public final boolean isSameAs(ItemStack comparableStack) {
        return ItemComparisonHelper.isEqualItemType(comparableStack, this.stack());
    }

    public final boolean isSameAs(AEKey key) {
        if (key instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)key;
            return this.item == itemKey.getItem();
        }
        return false;
    }

    public T asItem() {
        return this.item;
    }
}

