/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.render;

import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.LightDarkMode;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.RenderContext;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public record SimpleRenderContext(LytRect viewport, GuiGraphics guiGraphics, LightDarkMode lightDarkMode) implements RenderContext
{
    public SimpleRenderContext(LytRect viewport, GuiGraphics guiGraphics) {
        this(viewport, guiGraphics, LightDarkMode.current());
    }

    @Override
    public int resolveColor(ColorValue ref) {
        return ref.resolve(this.lightDarkMode);
    }

    @Override
    public void fillRect(LytRect rect, ColorValue topLeft, ColorValue topRight, ColorValue bottomRight, ColorValue bottomLeft) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f matrix = this.poseStack().last().pose();
        boolean z = false;
        builder.addVertex(matrix, (float)rect.right(), (float)rect.y(), 0.0f).setColor(this.resolveColor(topRight));
        builder.addVertex(matrix, (float)rect.x(), (float)rect.y(), 0.0f).setColor(this.resolveColor(topLeft));
        builder.addVertex(matrix, (float)rect.x(), (float)rect.bottom(), 0.0f).setColor(this.resolveColor(bottomLeft));
        builder.addVertex(matrix, (float)rect.right(), (float)rect.bottom(), 0.0f).setColor(this.resolveColor(bottomRight));
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    @Override
    public void fillTexturedRect(LytRect rect, AbstractTexture texture, ColorValue topLeft, ColorValue topRight, ColorValue bottomRight, ColorValue bottomLeft, float u0, float v0, float u1, float v1) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (int)texture.getId());
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Matrix4f matrix = this.poseStack().last().pose();
        boolean z = false;
        builder.addVertex(matrix, (float)rect.right(), (float)rect.y(), 0.0f).setUv(u1, v0).setColor(this.resolveColor(topRight));
        builder.addVertex(matrix, (float)rect.x(), (float)rect.y(), 0.0f).setUv(u0, v0).setColor(this.resolveColor(topLeft));
        builder.addVertex(matrix, (float)rect.x(), (float)rect.bottom(), 0.0f).setUv(u0, v1).setColor(this.resolveColor(bottomLeft));
        builder.addVertex(matrix, (float)rect.right(), (float)rect.bottom(), 0.0f).setUv(u1, v1).setColor(this.resolveColor(bottomRight));
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    @Override
    public void fillTriangle(Vec2 p1, Vec2 p2, Vec2 p3, ColorValue color) {
        int resolvedColor = this.resolveColor(color);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f matrix = this.poseStack().last().pose();
        boolean z = false;
        builder.addVertex(matrix, p1.x, p1.y, 0.0f).setColor(resolvedColor);
        builder.addVertex(matrix, p2.x, p2.y, 0.0f).setColor(resolvedColor);
        builder.addVertex(matrix, p3.x, p3.y, 0.0f).setColor(resolvedColor);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    @Override
    public void renderItem(ItemStack stack, int x, int y, int z, float width, float height) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack pose = this.poseStack();
        pose.pushPose();
        pose.translate((float)x, (float)y, (float)(z + 1));
        pose.scale(width / 16.0f, height / 16.0f, 1.0f);
        this.guiGraphics().renderItem(stack, 0, 0);
        this.guiGraphics().renderItemDecorations(mc.font, stack, 0, 0);
        pose.popPose();
    }
}

