/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.interaction;

import appeng.client.Point;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.interaction.GuideTooltip;
import appeng.client.guidebook.document.interaction.InteractiveElement;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.RenderContext;
import appeng.client.guidebook.screen.GuideScreen;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;

public class LytWidget
extends LytBlock
implements InteractiveElement {
    private final AbstractWidget widget;

    public LytWidget(AbstractWidget widget) {
        this.widget = widget;
    }

    @Override
    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        return new LytRect(x, y, this.widget.getWidth(), this.widget.getHeight());
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
        this.widget.setX(this.widget.getX() + deltaX);
        this.widget.setY(this.widget.getY() + deltaY);
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
    }

    @Override
    public void render(RenderContext context) {
        this.updateWidgetPosition();
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (!(screen instanceof GuideScreen)) {
            return;
        }
        GuideScreen guideScreen = (GuideScreen)screen;
        double mouseX = minecraft.mouseHandler.xpos() * (double)minecraft.getWindow().getGuiScaledWidth() / (double)minecraft.getWindow().getScreenWidth();
        double mouseY = minecraft.mouseHandler.ypos() * (double)minecraft.getWindow().getGuiScaledHeight() / (double)minecraft.getWindow().getScreenHeight();
        Point mouseDocPos = guideScreen.getDocumentPoint(mouseX, mouseY);
        this.widget.render(context.guiGraphics(), mouseDocPos != null ? mouseDocPos.getX() : -100, mouseDocPos != null ? mouseDocPos.getY() : -100, minecraft.getTimer().getRealtimeDeltaTicks());
    }

    private void updateWidgetPosition() {
        this.widget.setPosition(this.bounds.x(), this.bounds.y());
    }

    @Override
    public boolean mouseMoved(GuideScreen screen, int x, int y) {
        this.widget.mouseMoved((double)x, (double)y);
        return true;
    }

    @Override
    public boolean mouseClicked(GuideScreen screen, int x, int y, int button) {
        return this.widget.mouseClicked((double)x, (double)y, button);
    }

    @Override
    public boolean mouseReleased(GuideScreen screen, int x, int y, int button) {
        return this.widget.mouseReleased((double)x, (double)y, button);
    }

    @Override
    public Optional<GuideTooltip> getTooltip(float x, float y) {
        return Optional.empty();
    }

    public AbstractWidget getWidget() {
        return this.widget;
    }
}

