/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block.recipes;

import appeng.client.guidebook.document.DefaultStyles;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytSlot;
import appeng.client.guidebook.document.block.LytSlotGrid;
import appeng.client.guidebook.document.block.recipes.LytRecipeBox;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.RenderContext;
import appeng.core.AppEng;
import appeng.siteexport.ExportableResourceProvider;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LytSmithingRecipe
extends LytRecipeBox
implements ExportableResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LytSmithingRecipe.class);
    private static final ResourceLocation ARROW_LIGHT = AppEng.makeId("ae2guide/gui/recipe_arrow_light.png");
    private static final ResourceLocation ARROW_DARK = AppEng.makeId("ae2guide/gui/recipe_arrow_dark.png");
    private final SmithingRecipe recipe;
    private final LytSlotGrid inputGrid;
    private final LytSlot resultSlot;

    public LytSmithingRecipe(RecipeHolder<SmithingRecipe> holder) {
        super(holder);
        this.recipe = (SmithingRecipe)holder.value();
        this.setPadding(5);
        this.paddingTop = 15;
        this.inputGrid = LytSlotGrid.row(LytSmithingRecipe.getIngredients(this.recipe), true);
        this.append(this.inputGrid);
        this.resultSlot = new LytSlot(this.recipe.getResultItem((HolderLookup.Provider)Platform.getClientRegistryAccess()));
        this.append(this.resultSlot);
    }

    @NotNull
    private static List<Ingredient> getIngredients(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)recipe;
            return List.of(trimRecipe.template, trimRecipe.base, trimRecipe.addition);
        }
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)recipe;
            return List.of(transformRecipe.template, transformRecipe.base, transformRecipe.addition);
        }
        LOG.warn("Cannot determine ingredients of smithing recipe type {}", (Object)recipe.getClass());
        return List.of();
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        LytRect inputBounds = this.inputGrid.layout(context, x, y, availableWidth);
        LytRect resultBounds = this.resultSlot.layout(context, inputBounds.right() + 28, y, availableWidth);
        return LytRect.union(inputBounds, resultBounds);
    }

    @Override
    public void render(RenderContext context) {
        context.renderPanel(this.getBounds());
        context.renderItem(Blocks.SMITHING_TABLE.asItem().getDefaultInstance(), this.bounds.x() + this.paddingLeft, this.bounds.y() + 4, 8.0f, 8.0f);
        context.renderText(Items.SMITHING_TABLE.getDescription().getString(), DefaultStyles.CRAFTING_RECIPE_TYPE.mergeWith(DefaultStyles.BASE_STYLE), this.bounds.x() + this.paddingLeft + 10, this.bounds.y() + 4);
        context.fillTexturedRect(new LytRect(this.bounds.right() - 25 - 24, this.bounds.y() + 10 + (this.bounds.height() - 27) / 2, 24, 17), context.isDarkMode() ? ARROW_DARK : ARROW_LIGHT);
        super.render(context);
    }
}

