/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block.recipes;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytSlot;
import appeng.client.guidebook.document.block.recipes.LytRecipeBox;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.RenderContext;
import appeng.core.AppEng;
import appeng.recipes.handlers.InscriberRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;

public class LytInscriberRecipe
extends LytRecipeBox {
    private static final ResourceLocation ARROWS_LIGHT = AppEng.makeId("ae2guide/gui/inscriber_arrows_bg_light.png");
    private static final ResourceLocation ARROWS_DARK = AppEng.makeId("ae2guide/gui/inscriber_arrows_bg_dark.png");
    private final InscriberRecipe recipe;
    private final LytSlot topSlot;
    private final LytSlot middleSlot;
    private final LytSlot bottomSlot;
    private final LytSlot resultSlot;

    public LytInscriberRecipe(RecipeHolder<InscriberRecipe> holder) {
        super(holder);
        this.recipe = (InscriberRecipe)holder.value();
        this.topSlot = new LytSlot(this.recipe.getTopOptional());
        this.append(this.topSlot);
        this.middleSlot = new LytSlot(this.recipe.getMiddleInput());
        this.append(this.middleSlot);
        this.bottomSlot = new LytSlot(this.recipe.getBottomOptional());
        this.append(this.bottomSlot);
        this.resultSlot = new LytSlot(this.recipe.getResultItem());
        this.append(this.resultSlot);
        this.resultSlot.setLargeSlot(true);
        this.setPadding(5);
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        this.topSlot.layout(context, x, y, availableWidth);
        this.middleSlot.layout(context, x + 18, y + 23, availableWidth);
        this.bottomSlot.layout(context, x, y + 46, availableWidth);
        this.resultSlot.layout(context, x + 64, y + 20, availableWidth);
        return new LytRect(x, y, 90, 64);
    }

    @Override
    public void render(RenderContext context) {
        LytRect bounds = this.getBounds();
        context.renderPanel(bounds);
        context.fillTexturedRect(new LytRect(bounds.x() + 23, bounds.y() + 12, 46, 50), context.isDarkMode() ? ARROWS_DARK : ARROWS_LIGHT);
        super.render(context);
    }
}

