/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei;

import giselle.jei_mekanism_multiblocks.client.jei.MultiblockCategory;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import giselle.jei_mekanism_multiblocks.client.jei.category.BoilerCategory;
import giselle.jei_mekanism_multiblocks.client.jei.category.DynamicTankCategory;
import giselle.jei_mekanism_multiblocks.client.jei.category.EvaporationPlantCategory;
import giselle.jei_mekanism_multiblocks.client.jei.category.FissionReactorCategory;
import giselle.jei_mekanism_multiblocks.client.jei.category.FusionReactorCategory;
import giselle.jei_mekanism_multiblocks.client.jei.category.MatrixCategory;
import giselle.jei_mekanism_multiblocks.client.jei.category.SPSCategory;
import giselle.jei_mekanism_multiblocks.client.jei.category.TurbineCategory;
import giselle.jei_mekanism_multiblocks.common.JEI_MekanismMultiblocks;
import giselle.jei_mekanism_multiblocks.common.config.ClientConfig;
import giselle.jei_mekanism_multiblocks.common.config.JEI_MekanismMultiblocks_Config;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static JeiPlugin INSTANCE = null;
    private final List<MultiblockCategory<? extends MultiblockWidget>> categories;

    public static JeiPlugin instance() {
        return INSTANCE;
    }

    public ResourceLocation getPluginUid() {
        return JEI_MekanismMultiblocks.rl("jei_plugin");
    }

    public JeiPlugin() {
        INSTANCE = this;
        this.categories = new ArrayList<MultiblockCategory<? extends MultiblockWidget>>();
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        super.registerCategories(registration);
        ClientConfig config = JEI_MekanismMultiblocks_Config.CLIENT;
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.categories.clear();
        this.addCategory(config.dynamicTankVisible, () -> new DynamicTankCategory(guiHelper));
        this.addCategory(config.evaporationPlantVisible, () -> new EvaporationPlantCategory(guiHelper));
        this.addCategory(config.boilerVisible, () -> new BoilerCategory(guiHelper));
        this.addCategory(config.spsVisible, () -> new SPSCategory(guiHelper));
        this.addCategory(config.matrixVisible, () -> new MatrixCategory(guiHelper));
        if (JEI_MekanismMultiblocks.MekanismGeneratorsLoaded) {
            this.addCategory(config.turbineVisible, () -> new TurbineCategory(guiHelper));
            this.addCategory(config.fissionReactorVisible, () -> new FissionReactorCategory(guiHelper));
            this.addCategory(config.fusionReactorVisible, () -> new FusionReactorCategory(guiHelper));
        }
        for (MultiblockCategory<? extends MultiblockWidget> category : this.getCategories()) {
            registration.addRecipeCategories(new IRecipeCategory[]{category});
        }
    }

    private <CATEGOERY extends MultiblockCategory<?>> void addCategory(ModConfigSpec.BooleanValue config, Supplier<CATEGOERY> constructor) {
        if (((Boolean)config.get()).booleanValue()) {
            this.categories.add((MultiblockCategory)constructor.get());
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        super.registerRecipeCatalysts(registration);
        for (MultiblockCategory<? extends MultiblockWidget> category : this.getCategories()) {
            category.registerRecipeCatalysts(registration);
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        super.registerRecipes(registration);
        for (MultiblockCategory<? extends MultiblockWidget> category : this.getCategories()) {
            try {
                RecipeType<? extends MultiblockWidget> recipeType = category.getRecipeType();
                MultiblockWidget recipe = (MultiblockWidget)((Object)recipeType.getRecipeClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                registration.addRecipes(recipeType, Arrays.asList(recipe));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                System.err.println("Exception - " + String.valueOf(category.getRecipeType()));
                e.printStackTrace();
            }
        }
    }

    public List<MultiblockCategory<? extends MultiblockWidget>> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }
}

