/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class InventoryUtils {
    private static final double MOTION_SCALE = 0.05;

    public static void dropInventoryItems(Level world, BlockPos pos, IItemHandler itemHandler) {
        RandomSource random = world.random;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemStack = itemHandler.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            double offsetX = random.nextDouble() * 0.8 + 0.1;
            double offsetY = random.nextDouble() * 0.8 + 0.1;
            double offsetZ = random.nextDouble() * 0.8 + 0.1;
            ItemEntity entityitem = new ItemEntity(world, (double)pos.getX() + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + offsetZ, itemStack.copy());
            entityitem.setDeltaMovement(random.nextGaussian() * 0.05, random.nextGaussian() * 0.05 + 0.2, random.nextGaussian() * 0.05);
            world.addFreshEntity((Entity)entityitem);
        }
    }

    public static Optional<IItemHandler> getInventory(Level world, BlockPos pos, @Nullable Direction side) {
        return Optional.ofNullable((IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)side));
    }

    public static int transferItems(IItemHandler from, IItemHandler to, int slot, int count) {
        if (from == null || to == null || count == 0) {
            return 0;
        }
        ItemStack toSend = from.extractItem(slot, count, true);
        if (toSend.isEmpty()) {
            return 0;
        }
        ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)toSend, (boolean)false);
        int inserted = toSend.getCount() - excess.getCount();
        from.extractItem(slot, inserted, false);
        return inserted;
    }

    public static boolean dropItems(Level world, Vec3 pos, ItemStack stack) {
        if (!world.isClientSide) {
            ItemEntity item = new ItemEntity(world, pos.x(), pos.y(), pos.z(), stack);
            return world.addFreshEntity((Entity)item);
        }
        return true;
    }

    public static int countItems(ItemStack toCount, IItemHandler handler, int max, boolean matchMeta) {
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            boolean match = matchMeta ? stack.is(toCount.getItem()) && (!stack.isDamageableItem() || stack.getDamageValue() == toCount.getDamageValue()) : stack.is(toCount.getItem());
            if (match) {
                count += stack.getCount();
            }
            if (count < max) continue;
            return max;
        }
        return count;
    }
}

