/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.settings.ModuleFlags;
import me.desht.modularrouters.util.ItemTagMatcher;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.Validate;

public class SimpleItemMatcher
implements IItemMatcher {
    private final ItemStack filterStack;
    private ItemTagMatcher tagMatcher;

    public SimpleItemMatcher(ItemStack stack) {
        Validate.isTrue((!stack.isEmpty() ? 1 : 0) != 0);
        this.filterStack = stack;
    }

    @Override
    public boolean matchItem(ItemStack stack, ModuleFlags flags) {
        if (this.filterStack.getItem() == stack.getItem()) {
            return !(flags.matchDamage() && !this.matchDamage(stack, this.filterStack) || flags.matchComponents() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.filterStack));
        }
        if (flags.matchItemTags()) {
            return this.getTagMatcher().match(stack);
        }
        return false;
    }

    private ItemTagMatcher getTagMatcher() {
        if (this.tagMatcher == null) {
            this.tagMatcher = new ItemTagMatcher(this.filterStack);
        }
        return this.tagMatcher;
    }

    private boolean matchDamage(ItemStack stack1, ItemStack stack2) {
        return !stack1.isDamageableItem() || stack1.getDamageValue() == stack2.getDamageValue();
    }
}

