/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import com.google.common.base.Joiner;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.settings.ModuleFlags;
import me.desht.modularrouters.util.TranslatableEnum;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class InspectionMatcher
implements IItemMatcher {
    private final ComparisonList comparisonList;

    public InspectionMatcher(ComparisonList comparisons) {
        this.comparisonList = comparisons;
    }

    @Override
    public boolean matchItem(ItemStack stack, ModuleFlags flags) {
        int matched = 0;
        if (this.comparisonList.items.isEmpty()) {
            return false;
        }
        for (Comparison comp : this.comparisonList.items) {
            if (!comp.test(stack)) continue;
            if (!this.comparisonList.matchAll) {
                return true;
            }
            ++matched;
        }
        return matched >= this.comparisonList.items.size();
    }

    public record ComparisonList(List<Comparison> items, boolean matchAll) {
        private final List<Comparison> items;
        public static final ComparisonList DEFAULT = new ComparisonList(List.of(), false);
        public static final Codec<ComparisonList> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Comparison.CODEC.listOf().fieldOf("items").forGetter(ComparisonList::items), (App)Codec.BOOL.fieldOf("match_all").forGetter(ComparisonList::matchAll)).apply((Applicative)builder, ComparisonList::new));
        public static final StreamCodec<FriendlyByteBuf, ComparisonList> STREAM_CODEC = StreamCodec.composite((StreamCodec)Comparison.STREAM_CODEC.apply(ByteBufCodecs.list()), ComparisonList::items, (StreamCodec)ByteBufCodecs.BOOL, ComparisonList::matchAll, ComparisonList::new);

        public List<Comparison> items() {
            return Collections.unmodifiableList(this.items);
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        public ComparisonList setMatchAll(boolean matchAll) {
            return new ComparisonList(this.items(), matchAll);
        }

        public ComparisonList addComparison(Comparison toAdd) {
            ArrayList<Comparison> l = new ArrayList<Comparison>(this.items);
            l.add(toAdd);
            return new ComparisonList(List.copyOf(l), this.matchAll);
        }

        public ComparisonList removeAt(int pos) {
            ArrayList<Comparison> l = new ArrayList<Comparison>(this.items);
            if (pos >= 0 && pos < l.size()) {
                l.remove(pos);
            }
            return new ComparisonList(List.copyOf(l), this.matchAll);
        }
    }

    public record Comparison(InspectionSubject subject, InspectionOp op, int target) implements Predicate<ItemStack>
    {
        public static final Codec<Comparison> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)InspectionSubject.CODEC.fieldOf("subject").forGetter(Comparison::subject), (App)InspectionOp.CODEC.fieldOf("op").forGetter(Comparison::op), (App)Codec.INT.fieldOf("target").forGetter(Comparison::target)).apply((Applicative)builder, Comparison::new));
        public static final StreamCodec<FriendlyByteBuf, Comparison> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(InspectionSubject.class), Comparison::subject, (StreamCodec)NeoForgeStreamCodecs.enumCodec(InspectionOp.class), Comparison::op, (StreamCodec)ByteBufCodecs.INT, Comparison::target, Comparison::new);

        @Override
        public boolean test(ItemStack stack) {
            if (this.op == null || this.subject == null) {
                return false;
            }
            Optional<Integer> val = this.subject.evaluator.apply(stack);
            return this.op.test((long)val.orElse(-1), Long.valueOf(this.target));
        }

        @Override
        public String toString() {
            return Joiner.on((String)" ").join((Object)this.subject, (Object)this.op, new Object[]{this.target});
        }

        public MutableComponent asLocalizedText() {
            if (this.subject == null || this.op == null) {
                return Component.literal((String)"<?>");
            }
            return ClientUtil.xlate(this.subject.getTranslationKey(), new Object[0]).append(" ").append((Component)ClientUtil.xlate(this.op.getTranslationKey(), new Object[0])).append(this.target + this.subject.suffix);
        }
    }

    public static enum InspectionOp implements TranslatableEnum,
    StringRepresentable,
    BiPredicate<Long, Long>
    {
        NONE((val, target) -> false),
        GT((val, target) -> val > target),
        LT((val, target) -> val < target),
        LE((val, target) -> val <= target),
        GE((val, target) -> val >= target),
        EQ(Objects::equals),
        NE((val, target) -> !Objects.equals(val, target));

        public static final Codec<InspectionOp> CODEC;
        private final BiPredicate<Long, Long> predicate;

        private InspectionOp(BiPredicate<Long, Long> predicate) {
            this.predicate = predicate;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.inspectionOp." + String.valueOf(this);
        }

        @Override
        public boolean test(Long value, Long target) {
            return this.predicate.test(value, target);
        }

        public InspectionOp cycle(int direction) {
            int n = this.ordinal() + direction;
            if (n >= InspectionOp.values().length) {
                n = 0;
            } else if (n < 0) {
                n = InspectionOp.values().length - 1;
            }
            return InspectionOp.values()[n];
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(InspectionOp::values);
        }
    }

    public static enum InspectionSubject implements TranslatableEnum,
    StringRepresentable
    {
        NONE("none", "", stack -> Optional.empty()),
        DURABILITY("durability", "%", InspectionSubject::getDurabilityPercent),
        FLUID("fluid", "%", InspectionSubject::getFluidPercent),
        ENERGY("energy", "%", InspectionSubject::getEnergyPercent),
        ENCHANT("enchant", "", InspectionSubject::getHighestEnchantLevel),
        FOOD("food", "", InspectionSubject::getFoodValue);

        public static final Codec<InspectionSubject> CODEC;
        private final String name;
        private final String suffix;
        private final Function<ItemStack, Optional<Integer>> evaluator;

        private InspectionSubject(String name, String suffix, Function<ItemStack, Optional<Integer>> evaluator) {
            this.name = name;
            this.suffix = suffix;
            this.evaluator = evaluator;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.inspectionSubject." + this.name;
        }

        private static Optional<Integer> getDurabilityPercent(ItemStack stack) {
            return stack.getMaxDamage() > 0 ? Optional.of(InspectionSubject.asPercentage(stack.getMaxDamage() - stack.getDamageValue(), stack.getMaxDamage())) : Optional.empty();
        }

        private static Optional<Integer> getFoodValue(ItemStack stack) {
            return stack.has(DataComponents.FOOD) ? Optional.of(stack.getFoodProperties(null).nutrition()) : Optional.empty();
        }

        private static Optional<Integer> getHighestEnchantLevel(ItemStack stack) {
            return ((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).entrySet().stream().map(Object2IntMap.Entry::getIntValue).max(Comparator.naturalOrder());
        }

        private static Optional<Integer> getEnergyPercent(ItemStack stack) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            return storage == null ? Optional.empty() : Optional.of(InspectionSubject.asPercentage(storage.getEnergyStored(), storage.getMaxEnergyStored()));
        }

        private static Optional<Integer> getFluidPercent(ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
                int total = 0;
                int max = 0;
                for (int idx = 0; idx < handler.getTanks(); ++idx) {
                    max += handler.getTankCapacity(idx);
                    total += handler.getFluidInTank(idx).getAmount();
                }
                return Optional.of(InspectionSubject.asPercentage(total, max));
            }).orElse(Optional.empty());
        }

        public InspectionSubject cycle(int direction) {
            int n = this.ordinal() + direction;
            if (n >= InspectionSubject.values().length) {
                n = 0;
            } else if (n < 0) {
                n = InspectionSubject.values().length - 1;
            }
            return InspectionSubject.values()[n];
        }

        private static int asPercentage(int val, int max) {
            if (max == 0) {
                return 0;
            }
            return (int)((float)val / (float)max) * 100;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(InspectionSubject::values);
        }
    }
}

