/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import com.google.common.collect.Sets;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.settings.ModuleFlags;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class FluidMatcher
implements IItemMatcher {
    private final Fluid fluid;

    public FluidMatcher(ItemStack stack) {
        this.fluid = FluidUtil.getFluidContained((ItemStack)stack).map(FluidStack::getFluid).orElse(Fluids.EMPTY);
    }

    @Override
    public boolean matchItem(ItemStack stack, ModuleFlags flags) {
        return FluidUtil.getFluidContained((ItemStack)stack).map(fluidStack -> this.matchFluid(fluidStack.getFluid(), flags)).orElse(false);
    }

    @Override
    public boolean matchFluid(Fluid fluid, ModuleFlags flags) {
        return fluid == this.fluid || flags.matchItemTags() && !Sets.intersection(MiscUtil.fluidTags(fluid), MiscUtil.fluidTags(this.fluid)).isEmpty();
    }
}

